/***************************************************************************
    file	         : kb_form.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_FORM_H
#define	_KB_FORM_H

#include	<qaccel.h>
#include	<qintdict.h>

#include	"libkbase_exports.h"

#include	"kb_formblock.h"
#include	"kb_layout.h"
#include	"kb_conductor.h"
#include	"kb_docroot.h"



/*  KBForm								*/
/*  ----------								*/
/*  This node is the root of a particular XML form definition. It	*/
/*  handles things which are global to the form, such as field focus	*/
/*  and field movement and resizing, as well as representing the top-	*/
/*  most block.								*/

class	LIBKBASE_API	KBForm : public KBFormBlock, public KBLayout, public KBPlayer
{
	Q_OBJECT

	KBAttrStr	m_language	;	/* Form script language	*/
	KBAttrStr	m_caption	;	/* Form display caption	*/
	KBAttrBool	m_stretch	;	/* Stretch to window	*/
	KBAttrBool	m_modal		;	/* Form runs modal	*/
	KBAttrBool	m_hideBars	;	/* Hide menu/toolbars	*/
	KBAttrBool	m_hasStatusBar	;	/* Show status bar	*/

	KBEvent		m_onLoad	;
	KBEvent		m_onOpened	;
	KBEvent		m_onUnload	;
	KBEvent		m_onClose	;

	KBDocRoot	m_docRoot	;	/* Common document	*/
	KBDisplay	*m_display	;	/* Top-level display	*/

	KBItem		*m_formCurItem	;	/* ... block and item	*/
	uint		m_formCurQRow	;	/* Query row therein	*/

	KBValue		m_parentKey	;

	QAccel		*m_accel	;
	QIntDict<KBItem>m_accelMap	;

protected slots :

	void		accelerator	(int)	;

protected :

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	(cchar *) ;
#endif

signals :

	void		focusAtRow	(bool, uint, uint, bool) ;

public	:

	KBForm	(KBLocation &, const QDict<QString> &) ;
	KBForm	(KBLocation &, const QDict<QString> &, bool &) ;
virtual~KBForm	() ;


	virtual	KBForm		*isForm     () { return this        ; }
	virtual	KBLayout	*isLayout   () { return this        ; }
	virtual	KBDocRoot	*isDocRoot  () { return &m_docRoot  ; }

	virtual	KB::ObjType	objType		() ;

	virtual	void		printNode	(QString &, int)    ;

#if	! __KB_RUNTIME
	KBPopupMenu		*makeFramerPopup(KBFramer *, Qt::ButtonState  *) ;

	virtual bool		playerAdd	(const QStringList &, KBError &) ;
	virtual	bool		playerPerform	(const QString &, const QStringList &, KBError &) ;
	virtual	QString		playerName	() ;
#endif

	bool			formAction      (KB::Action)	    ;
	bool			moveFocusOK	(KBItem    *, uint) ;
	void			focusInEvent	(KBItem    *, uint) ;
	void			resize		(QSize)		    ;

	virtual bool		requery		() ;
	void			finish		() ;
	virtual	KBValue		*getBlockVal	() ;

	void			setFocusAtRow	(KBFormBlock *) ;

#if	! __KB_RUNTIME
	KB::ShowRC		showDesign	(QWidget  *, QSize &) ;
	KB::ShowRC		showPreview	(QWidget  *, QSize &) ;
#endif
	KB::ShowRC		showData	(QWidget  *, const QDict<QString> &, const KBValue &, QSize &) ;
	KB::ShowRC		showPrint	(KBWriter *) ;

	bool			queryClose	() ;
	bool			focusInBlock	(KBBlock  *) ;

	inline	KBDisplay	*getDisplay	()
	{
		return	m_display ;
	}

	inline	bool	hideMenuToolBars()
	{
		return	m_hideBars.getBoolValue () ;
	}

	inline	bool	hasStatusBar	()
	{
		return	m_hasStatusBar.getBoolValue () ;
	}

	inline	void	focusAtRow
		(	uint	qrow
		)
	{
		m_formCurQRow = qrow ;
	}

	void	addAccelerator	(const QKeySequence &, KBItem *) ;

	friend	class		KBFormBlock	;
}	;

#if	! __KB_RUNTIME
extern	LIBKBASE_API	bool	formPropDlg
			(	KBForm		*,
				cchar		*,
				QList<KBAttr  > &,
				QList<KBModule> &,
				QList<KBModule> &,
				QList<KBParam > &, 
				cchar		* = 0
			)	;
#endif
#endif	// _KB_FORM_H
