/***************************************************************************
    file	         : kb_framerdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#ifndef 	_WIN32
#include	"kb_framerdlg.moc"
#else
#include 	"kb_framerdlg.h"
#endif

#include	"kb_object.h"
#include	"kb_framer.h"

/*  KBFramerPropDlg							*/
/*  KBFramerPropDlg							*/
/*		: Constructor for framer properties dialog		*/
/*  framer	: KBFramer *	 : Associated framer			*/
/*  attribs	: QList<KBAttr>& : List of attributes			*/
/*  iniattr	: cchar *	 : Initial attribute			*/
/*  (returns)	: KBFramerPropDlg:					*/

KBFramerPropDlg::KBFramerPropDlg
	(	KBFramer	*framer,
		QList<KBAttr>	&attribs,
		cchar		*iniattr
	)
	:
	KBPropDlg
	(	framer,
		framer->	     isHeader() != 0 ? "Header"   :
		framer->	     isFooter() != 0 ? "Footer"   :
		framer->getParent()->isTabber() != 0 ? "Tab Page" :
						       "Container",
		attribs,
		iniattr
	),
	m_hiddenDlg	(&topWidget, framer)
{
	m_hiddenDlg.hide() ;
}

/*  KBFramerPropDlg							*/
/*  ~KBFramerPropDlg							*/
/*		: Destructor for block properties dialog		*/
/*  (returns)	: void		:					*/

KBFramerPropDlg::~KBFramerPropDlg ()
{
}


/*  KBFramerPropDlg:							*/
/*  preExec	  : Called immediately before QDialog::exec		*/
/*  (returns)	  : void	:					*/

void	KBFramerPropDlg::preExec ()
{
	/* Trap this and load the notional hidden attribute. We have to	*/
	/* do this here since it is not until "KBPropDlg::exec" has	*/
	/* been called that "setProperty" will work.			*/
	setProperty ("hidden", m_hiddenDlg.getText()) ;
}

/*  KBFramerPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBFramerPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	/* Hidden field. We just show the hidden field widget and	*/
	/* enable/disable to remove button appropriately.		*/
	if (aName == "hidden")
	{
		setUserWidget (&m_hiddenDlg) ;
		return	true  ;
	}

	return	KBPropDlg::showProperty (item) ;
}

/*  KBPropDlg								*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBFramerPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	/* Hidden fields						*/
	/* The actual information is in the list view, but stitch	*/
	/* together the appropriate string.				*/
	if (aName == "hidden")
	{
		setProperty (aName, m_hiddenDlg.getText()) ;
		return	true ;
	}

	return	KBPropDlg::saveProperty (item) ;
}

/*  KBFramerPropDlg:							*/
/*  clickOK	  : Handle OK button click				*/
/*  (returns)	  : void	:					*/

void	KBFramerPropDlg::clickOK ()
{
	m_hiddenDlg.clickOK () ;
	KBPropDlg ::clickOK () ;
}

/*  KBFramerPropDlg:							*/
/*  clickCancel	  : Handle cancel button click				*/
/*  (returns)	  : void	:					*/

void	KBFramerPropDlg::clickCancel ()
{
	m_hiddenDlg.clickCancel () ;
	KBPropDlg ::clickCancel () ;
}

/*  framerPropDlg							*/
/*		: Run block properties dialog				*/
/*  framer	: KBFramer *	  : Framer				*/
/*  attribs	: QList<KBAttr>&  : List of attributes			*/
/*  iniattr	: cchar *	  : Initial attribute			*/
/*  (returns)	: bool		  : Success				*/

bool	framerPropDlg
	(	KBFramer	*framer,
		QList<KBAttr>	&attribs,
		cchar		*iniattr
	)
{
	KBFramerPropDlg fDlg (framer, attribs, iniattr) ;
	return	fDlg.exec () ;
}
