/***************************************************************************
    file	         : kb_hidden.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_HIDDEN_H
#define	_KB_HIDDEN_H

#include	"libkbase_exports.h"

#include	"kb_classes.h"
#include	"kb_node.h"
#include	"kb_item.h"

/*  KBHidden								*/
/*  --------								*/
/*  This class is used to represent a KBHidden elements in the XML	*/
/*  form description, which provide for "hidden" fields used to get	*/
/*  values from the database server for the benefit of scripts.		*/ 

class	LIBKBASE_API KBHidden : public KBItem
{
	uint			nRows	;
	KBValue			*values	;

	KBValue			*valueAtQRow	(uint)	;

	void			init		()	;

protected :

#if	! __KB_RUNTIME
	virtual	bool	propertyDlg	() ;
#endif

public	:

	KBHidden (KBNode   *, const QDict<QString> &, bool * = 0) ;
	KBHidden (KBObject *, bool     &) ;
	KBHidden (KBNode   *, KBHidden *) ;
virtual~KBHidden () ;

	virtual	void		buildCtrls	(uint, int, int) ;
	virtual	KBNode		*replicate	(KBNode *) ;

	virtual	KBHidden	*isHidden	()     { return this  ; }

	virtual	KBValue		getValue	(uint) ;
	virtual	bool		setValue	(uint, const KBValue &) ;
	virtual	bool		isEmpty		(uint) ;
	virtual	void		clearValue	(uint, bool) ;
	virtual	bool		isValid		(uint, bool) ;
	virtual	bool		changed		(uint) ;

	virtual	uint		calcNumRows 	(int,  int,  uint    ) ;
	virtual	uint		calcNumRows 	(uint, uint, int, int) ;
	virtual void		extendCtrls	(uint, int, int) ;

	virtual	void		hideBelow	(uint)		{} ;
	virtual	void		showAs  	(KB::ShowAs)	{} ;

	virtual	bool	ctrlGeometry
		(	uint	,
			QRect &
		)
	{
		return	false	;
	}
	inline	void	setNameAndExpr
		(	const QString	&_name,
			const QString	&_expr
		)
	{
		name.setValue (_name) ;
		expr.setValue (_expr) ;
	}

	friend	class	KBHiddenDlg	;
}	;

#endif	// _KB_HIDDEN_H
