/***************************************************************************
    file	         : kb_linkdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qframe.h>
#include	<qmessagebox.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"

#include	"kb_attr.h"
#include	"kb_dbinfo.h"
#include	"kb_propdlg.h"
#include	"kb_qrybase.h"
#include	"kb_block.h"
#include	"kb_link.h"

#ifndef 	_WIN32
#include	"kb_linkdlg.moc"
#else
#include	"kb_linkdlg.h"
#endif


/*  KBLinkPropDlg							*/
/*  KBLinkPropDlg: Constructor for block properties dialog		*/
/*  link	 : KBLink *	 : Parent link				*/ 
/*  caption	 : const char *  : Dialog box caption			*/
/*  attribs	 : QList<KBAttr>&: List of attributes			*/
/*  (returns)	 : KBLinkPropDlg :					*/

KBLinkPropDlg::KBLinkPropDlg
	(	KBLink		*link,
		cchar		*caption,
		QList<KBAttr>	&attribs
	)
	:
	KBItemPropDlg	(link, caption, attribs),
	m_bQuery	(this),
	m_link		(link)
{
	m_bQuery.setText     (TR("Query")) ;
	butLayout .addWidget (&m_bQuery, 1, 4) ;
	connect (&m_bQuery, SIGNAL(clicked()), SLOT(clickQuery())) ;
}

/*  KBLinkPropDlg							*/
/*  ~KBLinkPropDlg: Destructor for block properties dialog		*/
/*  (returns)	   : void	:					*/

KBLinkPropDlg::~KBLinkPropDlg ()
{
}

/*  KBLinkPropDlg							*/
/*  dropProperty: Drop property after user clicks ignore button		*/
/*  (returns)	: void		:					*/

void	KBLinkPropDlg::dropProperty ()
{
	KBItemPropDlg::dropProperty () ;
}

/*  KBLinkPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBLinkPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	/* Child							*/
	/* This should display a list of all columns available from	*/
	/* the associated query, although the user can type in an	*/
	/* arbitrary expression.					*/
	if (aName == "child")
	{
		KBQryBase    *query  ;

		if ((query = m_link->getQuery()) == 0)
			return	warning ("Block lacks a query") ;

		return	pickQueryField (query, 0, item->value()) ;
	}

	/* Show								*/
	/* This is the links display query. Show all the fields		*/
	/* associated with that query.					*/
	if (aName == "show")
	{
		KBQryBase *query ;

		if ((query = m_link->getQuery()) == 0)
			return	warning ("Block lacks a query") ;

		return	showQueryField (query, 0, item->value()) ;
	}

	return	KBItemPropDlg::showProperty (item) ;
}

/*  KBLinkPropDlg							*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBLinkPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	/* Child							*/
	/* In this case, copy back the current selection from the	*/
	/* combo box.							*/
	if (aName == "child")
	{
		setProperty (aName, comboBox.text(comboBox.currentItem())) ;
		return	true ;
	}

	/* Show								*/
	/* Copy the result back ....					*/
	if (aName == "show")
	{
		if (strcmp (editBox.text(), item->value()) != 0)
			setProperty (aName, editBox.text()) ;

		return	true ;
	}

	return	KBItemPropDlg::saveProperty (item) ;
}

void	KBLinkPropDlg::clickQuery ()
{
	m_link->getQuery()->propertyDlg () ;
}


/*  linkPropDlg	: Run the link properties dialog			*/
/*  link	: KBLink *	: Parent link				*/ 
/*  caption	: cchar * 	: Dialog box caption			*/
/*  attribs	: QList<KBAttr>&: List of attributes			*/
/*  (returns)	: bool		: Success				*/

bool	linkPropDlg
	(	KBLink		*link,
		cchar		*caption,
		QList<KBAttr>	&attribs
	)
{
	KBLinkPropDlg lDlg (link, caption, attribs) ;
	return	lDlg.exec () ;
}
