/***************************************************************************
    file	         : kb_macrodef.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_MACRODEF_H
#define	__KB_MACRODEF_H

#include	<qstring.h>
#include	<qstringlist.h>

#include	"kb_dom.h"
#include	"libkbase_exports.h"


/*  KBMacroArgDef							*/
/*  -------------							*/
/*  Class used to store definition of one macro argument. Contains the	*/
/*  type, the argument name, and a list of choices for a choice		*/
/*  argument.								*/

class	LIBKBASE_API KBMacroArgDef
{
public	:

	QString		m_type		;
	QString		m_arg		;
	QStringList	m_choices	;

	KBMacroArgDef	()		;
	KBMacroArgDef	(QDomElement &)	;
}	;

/*  KBMacroDef								*/
/*  ----------								*/
/*  Holds the definition of a macro, decoded from the XML definitions.	*/
/*  Stores the name, the arguments, and some descriptive blurb.		*/

class	LIBKBASE_API KBMacroDef
{
public	:

	QString		m_name		;
	QValueList<KBMacroArgDef>
			m_args		;
	QString		m_blurb		;

	KBMacroDef	(QDomElement &)	;

	static	void			loadMacroDefs	() ;
	static	const QStringList	&getMacroNames	() ;
	static	KBMacroDef		*getMacroDef	(const QString &) ;
}	;
#endif	// __KB_MACRODEF_H
