/***************************************************************************
    file	         : kb_module.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_MODULE_H
#define	_KB_MODULE_H

#include	"libkbase_exports.h"

#include	<stdarg.h>

#include	<qlist.h>
#include	<qdict.h>

#include	"kb_classes.h"
#include	"kb_node.h"


/*  KBModule								*/
/*  ------------							*/
/*  This node specifies information about scripting languages and	*/
/*  modules used by the form.						*/

class LIBKBASE_API	KBModule : public KBNode
{
	KBAttrStr	module	;

public	:

	KBModule	(KBNode *, cchar *, const QDict<QString> &, uint * = 0, bool * = 0) ;
	KBModule	(KBNode *, cchar *, cchar  *) ;
	KBModule	(KBNode *, cchar *, KBModule *) ;

virtual~KBModule	()		;

	inline	QString	getModuleName ()
	{
		return	module.getValue () ;
	}
	inline	void	setModuleName
		(	const QString	&name
		)
	{
		module.setValue (name) ;
	}

	virtual	KBModule	*isModule	() { return this ; }
}	;


#endif	// _KB_MODULE_H
