/***************************************************************************
    file	         : kb_multilistbox.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<qapp.h>
#include	<qpainter.h>

#include	"kb_multilistbox.h"



/*  KBMultiListBoxItem							*/
/*  KBMultiListBoxItem							*/
/*		: Constructor for multi-column list box item		*/
/*  parent	: KBMultiListBox *	: Parent listbox		*/
/*  after	: QListBoxItem *	: Item to insert after		*/
/*  values	: QStringList &		: Values for this entry		*/
/*  (returns)	: KBMultiListBoxItem	:				*/

KBMultiListBoxItem::KBMultiListBoxItem
	(	KBMultiListBox		*parent,
		QListBoxItem		*after,
		const QStringList	&values
	)
	:
	QListBoxItem	(parent, after),
	m_parent	(parent),
	m_values	(values)
{
	m_height	= parent->fontMetrics().lineSpacing() + 2 ;
	if ((int)m_height < QApplication::globalStrut().height())
		m_height = QApplication::globalStrut().height() ;
}

/*  KBMultiListBoxItem							*/
/*  KBMultiListBoxItem							*/
/*		: Constructor for multi-column list box item		*/
/*  parent	: KBMultiListBox *	: Parent listbox		*/
/*  after	: QListBoxItem *	: Item to insert after		*/
/*  value	: QString &		: Value				*/
/*  (returns)	: KBMultiListBoxItem	:				*/

KBMultiListBoxItem::KBMultiListBoxItem
	(	KBMultiListBox		*parent,
		QListBoxItem		*after,
		const QString		&value
	)
	:
	QListBoxItem	(parent, after),
	m_parent	(parent)
{
	m_values.append	(value)	;
	m_height	= parent->fontMetrics().lineSpacing() + 2 ;
	if ((int)m_height < QApplication::globalStrut().height())
		m_height = QApplication::globalStrut().height() ;
}

/*  KBMultiListBoxItem							*/
/*  width	: Calculate width of a specified column			*/
/*  fm		: const QFontMetrics &	: Font information		*/
/*  col		: uint			: Column			*/
/*  (returns)	: uint			: Width in pixels		*/

uint	KBMultiListBoxItem::width
	(	const QFontMetrics	&fm,
		uint			col
	)
{
	/* NOTE: This is also used to calculate the maximum height for	*/
	/* this row, assuming that it is called for all columns. Has a	*/
	/* three pixel marin at each end.				*/
	QSize	size	= fm.size (Qt::SingleLine, m_values[col]) ;
	if (size.height() > (int)m_height) m_height = size.height() ;
	return	size.width () + 6 ;
}

/*  KBMultiListBoxItem							*/
/*  height	: Return height						*/
/*  (returns)	: int		: Height				*/

int	KBMultiListBoxItem::height
	(	const QListBox		*
	)
	const
{
	return	m_height	;
}

/*  KBMultiListBoxItem							*/
/*  paint	: Paint this entry					*/
/*  p		: QPainter *	: Painter				*/
/*  (returns)	: void		:					*/

void	KBMultiListBoxItem::paint
	(	QPainter	*p
	)
{
	const QValueList<uint>	&widths = m_parent->widths() ;
	QFontMetrics		fm	= p->fontMetrics  () ;
	uint			offset	= 0 ;

	uint			showCols= m_parent->showCols () ;

	/* If we are to show a limited number of columns in the combo	*/
	/* box itself then see if the painter is onto the listbox	*/
	/* viewport; if so then this is the popup and we paint _all_	*/
	/* the columns.							*/
	if (showCols  > 0)
		if (p->device() == m_parent->viewport())
			showCols = 0xffff ;

	/* A value of zero is also interpreted as painting all the	*/
	/* columns.							*/
	if (showCols == 0)
		showCols = 0xffff ;


	for (uint idx = 0 ; idx < m_values.count() ; idx += 1)
	{
		if (idx >= showCols)
			break	;

		if ((idx > 0) && m_parent->colSep())
			p->drawLine (offset, 0, offset, m_height) ;

		p->drawText
		(	offset + 3,
			fm.ascent() + (fm.leading() + 1 ) / 2 + 1,
			m_values[idx]
		)	;

		offset	+= widths[idx] ;
	}
}

/*  KBMultiListBoxItem							*/
/*  text	: Get text value					*/
/*  (returns)	: QString	: Value					*/

QString	KBMultiListBoxItem::text () const
{
	/* Return the first value. This allows key selection to work	*/
	/* inside the list box.						*/
	return	m_values[0] ;
}


/*  ------------------------------------------------------------------  */

/*  KBMultiListBox							*/
/*  KBMultiListBox							*/
/*		: Constructor for multi-column listbox			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  colSep	: bool		: Display with column separators	*/
/*  showCols	: uint		: Columns to show in combo part		*/
/*  (returns)	: KBMultiListBox:					*/

KBMultiListBox::KBMultiListBox
	(	QWidget		*parent,
		bool		colSep,
		uint		showCols
	)
	:
	QListBox	(parent),
	m_colSep	(colSep),
	m_showCols	(showCols)
{
	clear	()	;
}

/*  KBMultiListBox							*/
/*  insertEntry	: Add an entry to the listbox				*/
/*  values	: QStringList &	: Values for entry			*/
/*  (returns)	: void		:					*/

void	KBMultiListBox::insertEntry
	(	const QStringList	&values
	)
{
	m_last = new KBMultiListBoxItem (this, m_last, values) ;
	if (values.count() > m_nCols) m_nCols = values.count() ;

	m_doCalc = true ;
}

/*  KBMultiListBox							*/
/*  insertEntry	: Add an entry to the listbox				*/
/*  value	: QString &	: Value for entry			*/
/*  (returns)	: void		:					*/

void	KBMultiListBox::insertEntry
	(	const QString	&value
	)
{
	m_last = new KBMultiListBoxItem (this, m_last, value) ;
	if (m_nCols < 1) m_nCols = 1 ;

	m_doCalc = true ;
}

/*  KBMultiListBox							*/
/*  calcGeometry: Calculate geometry					*/
/*  (returns)	: void		:					*/

void	KBMultiListBox::calcGeometry ()
{
//	fprintf
//	(	stderr,
//		"KBMultiListBox::calcGeometry: d=%d m_nCols=%d pw=%p\n",
//		m_doCalc,
//		m_nCols,
//		(void *)parentWidget()
//	)	;

	if (m_doCalc)
	{
		QFontMetrics fm (font()) ;

		m_widths.clear() ;

		/* First scan each column to find the maximum width	*/
		/* needed for said column.				*/
		for (uint col1 = 0 ; col1 < m_nCols ; col1 += 1)
		{
			uint	width	= 0 ;
			for (uint row = 0 ; row < count() ; row += 1)
			{	uint w = ((KBMultiListBoxItem *)item(row))->width (fm, col1) ;
				if (w > width) width = w ;
			}
			m_widths.append (width) ;
		}

		/* Sum the widths and use this for the overall width,	*/
		/* except that it is at least as wide as the parent.	*/
		int	tw = 0 ;
		for (uint col2 = 0 ; col2 < m_nCols ; col2 += 1)
			tw += m_widths[col2] ;

		/* HACK: Should get the scrollbar width properly from	*/
		/* the style or something.				*/
		tw += 20 ;

		/* HACK: For some reason, on the Zaurus at least, there	*/
		/* is not (always) a parent widget ....			*/
		if (parentWidget() != 0)
			if (tw < parentWidget()->width())
				tw = parentWidget()->width() ;

		setFixedWidth (tw) ;
		m_doCalc = false   ;
	}
}

/*  KBMultiListBox							*/
/*  clear	: Reset contents					*/
/*  (returns)	: void							*/

void	KBMultiListBox::clear ()
{
	QListBox::clear () ;
	m_widths .clear () ;
	m_nCols	 = 0	;
	m_last	 = 0 	;
	m_doCalc = true	;
}
