/***************************************************************************
    file	         : kb_optionsdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_OPTIONSDLG_H
#define	_KB_OPTIONSDLG_H


#include	<qlabel.h>
#include	<qcombobox.h>
#include	<qcheckbox.h>
#include	<qspinbox.h>
#include	<qpushbutton.h>
#include	<qradiobutton.h>
#include	<qvbuttongroup.h>
#include	<qtextview.h>
#include	<qlayout.h>
#include	<qtabwidget.h>

#include	"libkbase_exports.h"

#include	"kb_dialog.h"
#include	"kb_options.h"
#include	"tk_config.h"
#include	"tk_lineedit.h"



/*  KBVerifyOpts							*/
/*  ------------							*/
/*									*/
/*  Database verifcation options.						*/
/*									*/
class	LIBKBASE_API	KBVerifyOpts : public QWidget
{
	KBOptions	&m_options	;
	QLabel		m_lInsert	;
	QLabel		m_lUpdate	;
	QLabel		m_lDelete	;
	QLabel		m_lMulti	;

	QComboBox	m_cbInsert	;
	QComboBox	m_cbUpdate	;
	QComboBox	m_cbDelete	;
	QComboBox	m_cbMulti	;

	QGridLayout	m_layout	;

public	:

	KBVerifyOpts	(QWidget *, KBOptions &) ;

	void	 	save (TKConfig *) ;
}	;


/*  KBLayoutOpts							*/
/*  ------------							*/
/*									*/
/*  Form layout options.						*/
/*									*/
class	LIBKBASE_API	KBLayoutOpts : public QWidget
{
	KBOptions	&m_options	;

	QLabel		m_lGrid		;
	QLabel		m_lGridX	;
	QLabel		m_lGridY	;
	QLabel		m_lForm		;
	QLabel		m_lFormW	;
	QLabel		m_lFormH	;
	QLabel		m_lDefD		;
	QLabel		m_lDefDX	;
	QLabel		m_lDefDY	;
	QLabel		m_lSpace	;

	QSpinBox	m_sGridX	;
	QSpinBox	m_sGridY	;
	QSpinBox	m_sFormW	;
	QSpinBox	m_sFormH	;
	QSpinBox	m_sDefDX	;
	QSpinBox	m_sDefDY	;
	QSpinBox	m_sSpace	;

	QGridLayout	m_layout	;

public	:

	KBLayoutOpts	(QWidget *, KBOptions &) ;

	void	 	save (TKConfig *) ;
}	;


/*  KBInterfaceOpts							*/
/*  ---------------							*/
/*									*/
/*  User interface options (MDI/SDI) and others				*/
/*									*/

class	LIBKBASE_API	KBInterfaceOpts : public QWidget
{
	Q_OBJECT

	KBOptions	&m_options	;

#if	! __KB_EMBEDDED
	QVButtonGroup	m_useGroup	;
	QRadioButton	m_useMDI	;
	QRadioButton	m_useSDI	;
#endif
	QCheckBox	m_openLast	;
	QCheckBox	m_singleDBOnly	;

	QPushButton	m_bSetup	;

	QVBoxLayout	m_layout	;

protected slots :

	void		resetSetup ()	;

public	:

	KBInterfaceOpts	(QWidget *, KBOptions &) ;

	void	 	save (TKConfig *) ;
}	;


/*  KBModalOpts								*/
/*  -----------								*/
/*									*/
/*  Modal execution options						*/
/*									*/

class	LIBKBASE_API	KBModalOpts : public QWidget
{
	KBOptions	&m_options	;

	QCheckBox	m_tablesModal	;
	QCheckBox	m_formsModal	;
	QCheckBox	m_reportsModal	;
	QCheckBox	m_queriesModal	;

	QVBoxLayout	m_layout	;

public	:

	KBModalOpts	(QWidget *, KBOptions &) ;

	void	 	save (TKConfig *) ;
}	;


/*  KBReportOpts							*/
/*  ------------							*/
/*									*/
/*  Report layout options						*/
/*									*/
class	LIBKBASE_API	KBReportOpts : public QWidget
{
	KBOptions	&m_options	;

	QLabel		m_llMargin	;
	QLabel		m_lrMargin	;
	QLabel		m_ltMargin	;
	QLabel		m_lbMargin	;
	QLabel		m_lDPI		;

	QSpinBox	m_slMargin	;
	QSpinBox	m_srMargin	;
	QSpinBox	m_stMargin	;
	QSpinBox	m_sbMargin	;
	QSpinBox	m_sDPI		;

	QCheckBox	m_cbDesign	;

	QGridLayout	m_layout	;

public	:

	KBReportOpts	(QWidget *, KBOptions &) ;

	void	 	save (TKConfig *) ;
}	;

/*  KBPythonOpts							*/
/*  ------------							*/
/*									*/
/*  Python interpreter options.						*/
/*  NOTE: This should really be part of the python interpreter library.	*/
/*									*/

class	LIBKBASE_API	KBPythonOpts : public QWidget
{
	Q_OBJECT

	KBOptions	&m_options	;

	QCheckBox	m_eUserpy	;

#if	__KB_USESYSPY
	QLabel		m_lVersion	;
	QComboBox	m_eVersion	;
#endif
	QLabel		m_lBinpath	;
	QLabel		m_lPypath	;

	TKLineEdit	m_eBinpath	;
	TKLineEdit	m_ePypath	;

	QGridLayout	m_layout	;

protected slots :

	void		changeUserPY ()	;

public	:

	KBPythonOpts	(QWidget *, KBOptions &) ;

	void	 	save (TKConfig *) ;
}	;


/*  KBScriptOpts								*/
/*  ----------								*/
/*									*/
/*  Global font options							*/
/*									*/
class	LIBKBASE_API	KBScriptOpts : public QWidget
{
	Q_OBJECT

	KBOptions	&m_options	;

#if	! __KB_EMBEDDED
	QLabel		m_lScriptFont	;
	TKLineEdit	m_eScriptFont	;
	QPushButton	m_bScriptFont	;
#endif
	QLabel		m_lScriptType	;
	QComboBox	m_cbScriptType	;
	QLabel		m_lMacroDebug	;
	QComboBox	m_cbMacroDebug	;

	QGridLayout	m_layout	;

private slots :

	void		clickSetScriptFont    () ;

public	:

	KBScriptOpts	(QWidget *, KBOptions &) ;

	void	 	save (TKConfig *) ;
}	;

/*  KBLoggingOpts							*/
/*  -------------							*/
/*									*/
/*  Global logging options							*/
/*									*/
class	LIBKBASE_API	KBLoggingOpts : public QWidget
{
	Q_OBJECT

	KBOptions	&m_options	;

	QLabel		m_lMaxQueries	;
	QSpinBox	m_sMaxQueries	;
	QLabel		m_lMaxEvents	;
	QSpinBox	m_sMaxEvents	;
	QLabel		m_lMaxArgs	;
	QSpinBox	m_sMaxArgs	;
	QLabel		m_lMaxArgLen	;
	QSpinBox	m_sMaxArgLen	;

	QGridLayout	m_layout	;

public	:

	KBLoggingOpts	(QWidget *, KBOptions &) ;

	void	 	save (TKConfig *) ;
}	;

/*  KBOptions								*/
/*  ---------								*/
/*									*/
/*  Global options dialog						*/
/*									*/
class	LIBKBASE_API	KBOptionsDlg : public _KBDialog
{
	Q_OBJECT

#if	! __KB_EMBEDDED
	QTextView	m_blurb		;
#endif
	QTabWidget	m_tabber	;

	KBVerifyOpts	*m_verify	;
	KBInterfaceOpts	*m_interface	;
	KBModalOpts	*m_modal	;
	KBLayoutOpts	*m_layout	;
	KBReportOpts	*m_report	;
#ifndef _WIN32
	KBPythonOpts	*m_python	;
#endif
#if	! __KB_EMBEDDED
	KBScriptOpts	*m_scripts	;
#endif
	KBLoggingOpts	*m_logging	;

	QPushButton	m_bOK		;
	QPushButton	m_bCancel	;


protected slots :

	virtual	void	accept		()	;
	virtual	void	reject		()	;
	void		pageChanged	(QWidget  *) ;

public	:

	KBOptionsDlg (QWidget *) ;

	static	void	setupWizard	(TKConfig *) ;
}	;

#endif	// _KB_OPTIONSDLG_H
