/***************************************************************************
    file	         : kb_parse.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_PARSE_H
#define	_KB_PARSE_H


#include	<qcstring.h>
#include	<qstring.h>
#include	<qlist.h>
#include	<qxml.h>
#include	<qdict.h>

#include	"libkbase_exports.h"


class	KBEvent		;
class	KBMacroExec	;

/*  KBSAXHandler							*/
/*  ------------							*/
/*  This class, itself derived from QXmlDefaultHandler, is used as the	*/
/*  base for the KBase parsers (for forms, queries and reports).	*/

class	LIBKBASE_API	KBSAXHandler : public QXmlDefaultHandler
{
protected :

	enum	ParseState
	{
		Normal,
		InEvent,
		InSlot,
		InSlotLink,
		InSlotCode,
		InMacro,
		InMacroInstr,
		InMacroArg
	}	;

	cchar		*m_what		;	/* What's being parsed	*/
	KBLocation	m_location	;	/* Database location	*/
	KBError		m_lError	;	/* Error message	*/
	bool		m_bGotErr	;	/* Error occurred flag	*/

	KBNode		*m_kbTOS	;	/* Top of parse stack	*/
	KBNode		*m_kbTop	;	/* Top-most parsed node	*/

	ParseState	m_state		;

	KBSlot		*m_kbSlot	;	/* Current slot if any	*/
	KBEvent		*m_kbEvent	;	/* Current event if any	*/
	KBMacroExec	*m_kbMacro	;	/* Current macro if any	*/

	QString		m_macroAction	;
	QString		m_macroComment	;
	QStringList	m_macroArgs	;

	QString		m_chars		;


	void	setErrMessage	(const QXmlParseException       &) ;
	void	setErrMessage	(const QString &, const QString &) ;
	void	setErrMessage	(const QString &, ParseState	 ) ;

	bool	parse		(QXmlInputSource &) ;
	bool	parseFile	(const QString   &) ;
	bool	parseText	(QByteArray      &) ;

public	:

	KBSAXHandler (cchar *, KBLocation &, KBNode *) ;

	virtual	bool	characters	(const QString &) ;
	virtual	bool	startElement	(const QString &, const QString &, const QString &, const QXmlAttributes &) = 0 ;
	virtual	bool	endElement	(const QString &, const QString &, const QString &) ;
	virtual	bool	error		(const QXmlParseException &) ;
	virtual	bool	warning		(const QXmlParseException &) ;
	virtual	bool	fatalError	(const QXmlParseException &) ;

	bool		processNode	(const QString &, const QDict<QString> &, const QDict<NodeSpec> &) ;

	inline	const KBError	&lastError () { return m_lError  ; }

}	;



extern LIBKBASE_API	uint	LoadNodeFuncs		(uint, int, QDict<NodeSpec> &) ;

extern LIBKBASE_API	KBForm	*KBOpenFormText
			(	KBLocation	&,
				QByteArray	&,
				KBError		&
			)	;

extern LIBKBASE_API	KBReport*KBOpenReportText
			(	KBLocation	&,
				QByteArray	&,
				KBError		&
			)	;

extern LIBKBASE_API	KBQuery	*KBOpenQueryText
			(	KBLocation	&,
				QByteArray	&,
				KBError		&
			)	;

extern LIBKBASE_API	KBComponent
				*KBOpenComponentText
			(	KBLocation	&,
				QByteArray	&,
				KBError		&
			)	;


#endif	// _KB_PARSE_H
