/***************************************************************************
    file	         : kb_parseform.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>

#include	<qxml.h>
#include	<qpopupmenu.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_form.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"


static	uint pNodeFns;
static 	QDict<NodeSpec>	formNodeDict;



/*  KBFormhandler							*/
/*  -------------							*/
/*  Handler for parsing forms.						*/

class	LIBKBASE_API KBFormHandler : public KBSAXHandler
{
	KBForm		*m_kbForm	;	/* Root of parsed form	*/

public	:

	KBFormHandler (KBLocation &, KBNode *) ;

	virtual	bool	startElement	(const QString &, const QString &, const QString &, const QXmlAttributes &) ;

	KBForm	*parseFile (const QString &) ;
	KBForm	*parseText (QByteArray	  &) ;
}	;


/*  KBFormHandler							*/
/*  KBFormHandler: Constructor for form parser				*/
/*  location	 : KBLocation *	 : Database location			*/
/*  parent	 : KBNode *	 : Initial parent node			*/
/*  (returns)	 : KBFormHandler :					*/

KBFormHandler::KBFormHandler
	(	KBLocation	&location,
		KBNode		*parent
	)
	:
	KBSAXHandler ("form", location, parent)
{
	m_kbForm = 0 ;
}

/*  KBFormHandler							*/
/*  startElement: Handle start of element				*/
/*  URI		: const QString &	: Namespace URI			*/
/*  localName	: const QString &	:				*/
/*  qName	: const QString &	: Element name			*/
/*  attribs	: const QXmlAttributes &: Attribute list		*/
/*  (returns)	: bool			:				*/

bool	KBFormHandler::startElement
	(	const	QString		&,
		const	QString		&,
		const	QString		&qName,
		const	QXmlAttributes	&attribs
	)
{
	/* The QXmlAttributes are converted to a QDict<QString>		*/
	/* dictionary. This is done since by passing attributes in this	*/
	/* way, it is easy to construct forms on the fly.		*/
	QDict<QString>	aList	   ;
	aList.setAutoDelete (true) ;
	for (int idx = 0 ; idx < attribs.length() ; idx += 1)
		aList.insert (attribs.qName (idx), new QString (attribs.value(idx))) ;


	/* Check for the root of the form. This is a special case, as	*/
	/* we need to construct and note the form root node.		*/
	if (qName == "KBForm")
	{
		m_kbTOS	= m_kbForm = new KBForm (m_location, aList) ;
		m_kbForm->startParse () ; 
		return	true ;
	}

	/* Check also for pasting a component, in which case create a	*/
	/* dummy form object at the top level.				*/
	if (qName == "KBComponent")
	{
		m_kbTOS	= m_kbForm = new KBForm (m_location, aList) ;
		m_kbForm->startParse ()     ; 
		return	true ;
	}

	if (m_kbTOS == 0)
	{
		setErrMessage (TR("Expected KBForm element at topmost level, got %1"), qName) ;
		return	false ;
	}

	return	processNode (qName, aList, formNodeDict) ;
}

/*  KBFormHandler							*/
/*  parseFile	: Parse form from file					*/
/*  document	: const QString & : Form document file			*/
/*  (returns)	: KBForm *	  : Form root or null on error		*/

KBForm	*KBFormHandler::parseFile
	(	const QString	&document
	)
{
	/* All of the work is done by the base parse method, which	*/
	/* picks up on errors and empty documents.			*/
	if (!KBSAXHandler::parseFile (document)) return 0 ;

	return	m_kbForm ;
}

/*  KBFormHandler							*/
/*  parseText	: Parse form from text					*/
/*  document	: QByteArray &	: Form document text			*/
/*  (returns)	: KBForm *	: Form root or null on error		*/

KBForm	*KBFormHandler::parseText
	(	QByteArray	&document
	)
{
	/* All of the work is done by the base parse method, which	*/
	/* picks up on errors and empty documents.			*/
	if (!KBSAXHandler::parseText (document)) return 0 ;

	return	m_kbForm ;
}


/*  FrmLoadNodeFuncs							*/
/*		: Load new node definition functions			*/
/*  (returns)	: void		:					*/

static	void FrmLoadNodeFuncs ()
{
	pNodeFns = LoadNodeFuncs (pNodeFns, KF_FORM, formNodeDict) ;

}

/*  KBOpenFormText							*/
/*		: Open a form document from a file			*/
/*  location	: KBLocation &	 : Form location			*/
/*  document	: cchar *	 : Form document text			*/
/*  pError	: KBError &	 : Error return				*/
/*  (returns)	: KBForm	 : Document root or null		*/

KBForm	*KBOpenFormText
	(	KBLocation	&location,
		QByteArray	&document,
		KBError		&pError
	)
{
	FrmLoadNodeFuncs () ;

	/* Create and initialise the SAX parser and the document and	*/
	/* error handlers (which are actually one and the same.		*/
	KBFormHandler  	handler (location, 0) ;
	KBForm		*form	= handler.parseText (document) ;

	if (form == 0)
	{	pError	= handler.lastError () ;
		return	0 ;
	}

	return	form	;
}


QDict<NodeSpec>	&getFormNodeDict ()
{
	FrmLoadNodeFuncs ()  ;
	return	formNodeDict ;
}


/*  ------------------------------------------------------------------  */

/*  makeFormMenu: Insert node entries into form popup design menu	*/
/*  popup	: QPopupMenu *	: Popup menu being constructed		*/
/*  receiver	: QObject *	: Received for menu signals		*/
/*  flags	: uint		: Inclusion flags			*/
/*  (returns)	: void		:					*/

void	makeFormMenu
	(	QPopupMenu	*popup,
		QObject		*receiver,
		uint		flags
	)
{
	extern	void	 makeDesignMenu (QDict<NodeSpec> &, QPopupMenu *, QObject *, uint) ;
	FrmLoadNodeFuncs () ;
	makeDesignMenu	 (formNodeDict, popup, receiver, flags) ;
}

/*  findFormNodeSpec							*/
/*		: Find node spec for named node				*/
/*  nodeName	: const QString & : Node name				*/
/*  (returns)	: NodeSpec *	  : Node specification or null		*/

NodeSpec*findFormNodeSpec
	(	const QString	&nodeName
	)
{
	FrmLoadNodeFuncs () ;

	return	formNodeDict.find (nodeName) ;
}
