/***************************************************************************
    file	         : kb_popupmenu.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_POPUPMENU_H
#define	__KB_POPUPMENU_H

#include	<qlist.h>
#include	<qpopupmenu.h>

#include	"libkbase_exports.h"


/*  KBPopupMenu								*/
/*  -----------								*/
/*  This class extends QPopupMenu such that :				*/
/*  (a)	Key state present when the mouse button is released is noted	*/
/*  (b) Insert methods have a disabled option				*/
/*  (c) Inserted submenus are destroyed when the menu itself is		*/

class LIBKBASE_API	KBPopupMenu : public QPopupMenu
{
	Qt::ButtonState		*lvstate ;
	QList<KBPopupMenu>	subMenus ;

protected :

	virtual	void	mouseReleaseEvent (QMouseEvent *) ;

public	:

	KBPopupMenu (Qt::ButtonState *) ;
       ~KBPopupMenu () ;

	void	insertEntry (bool, const QString &, KBPopupMenu *) ;	
	void	insertEntry (bool, const QString &, const QObject *, const char *) ;
}	;

#endif	// __KB_POPUPMENU_H
