/***************************************************************************
    file	         : kb_prompt.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_PROMPTDLG
#define	_KB_PROMPTDLG

#include	<qdialog.h>
#include	<qlayout.h>
#include	<qpushbutton.h>
#include	<qlabel.h>
#include	<qcombobox.h>
#include	<qstringlist.h>

#include	"libkbase_exports.h"

#include	"kb_dialog.h"
#include	"tk_lineedit.h"



/*  KBPromptDlg								*/
/*  -----------								*/
/*  Basic prompt dialog.						*/

class	LIBKBASE_API	KBPromptDlg : public _KBDialog
{
protected :

	QPushButton	m_bOK		;
	QPushButton	m_bCancel	;
	QLabel		m_tMessage	;
	TKLineEdit	m_tValue	;
	QString		&m_value	;

	QVBoxLayout	*m_lMain	;
	QHBoxLayout	*m_lButton	;

protected slots :

	virtual	void	accept () ;

public	:

	KBPromptDlg (const QString &, const QString &, QString &) ;
       ~KBPromptDlg () ;
}	;

/*  KBPromptDlg								*/
/*  -----------								*/
/*  Basic save dialog, showing combo box of possible document		*/
/*  locations.								*/

class	LIBKBASE_API	KBPromptSaveDlg : public _KBDialog
{
protected :

	QPushButton	m_bOK		;
	QPushButton	m_bCancel	;
	QLabel		m_tMessage	;
	TKLineEdit	m_tValue	;
	QComboBox	m_cWhere	;
	QString		&m_value	;
	QString		&m_where	;
	bool		m_incfiles	;

	QVBoxLayout	*m_lMain	;
	QHBoxLayout	*m_lButton	;

protected slots :

	virtual	void	accept () ;

public	:

	KBPromptSaveDlg (const QString &, const QString &, QString &, QString &, KBDBInfo *, bool) ;
       ~KBPromptSaveDlg () ;
}	;


class	LIBKBASE_API	KBChoiceDlg : public _KBDialog
{
	QPushButton	m_bOK		;
	QPushButton	m_bCancel	;
	QLabel		m_tMessage	;
	QComboBox	m_cValues	;
	QString		&m_value	;

protected :

	QVBoxLayout	*m_lMain	;
	QHBoxLayout	*m_lButton	;

protected slots :

	virtual	void	accept () ;

public	:

	KBChoiceDlg (const QString &, const QString &, QStringList &, QString &) ;
       ~KBChoiceDlg () ;
}	;

extern	bool	LIBKBASE_API	doPrompt
		(	const	QString	&caption,
			const	QString	&message,
			QString		&value
		)	;

extern	bool	LIBKBASE_API	doPromptSave
		(	const QString	&caption,
			const QString	&message,
			QString		&value,
			QString		&where,
			KBDBInfo	*dbInfo,
			bool		incfiles
		)	;


#endif	// _KB_PROMPTDLG
