/***************************************************************************
    file	         : kb_qtrichtext.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qcursor.h>

#ifndef 	_WIN32
#include 	"kb_qtrichtext.moc"
#else
#include 	"kb_qtrichtext.h"
#endif

#include	"kb_richtext.h"
#include	"kb_block.h"
#include	"kb_display.h"
#include	"kb_writer.h"




/*  KBCtrlRichText							*/
/*  KBCtrlRichText							*/
/*		: Constructor for line edit wrapper			*/
/*  display	: KBDisplay *	: Parent display			*/
/*  field	: KBField *	: Parent field				*/
/*  drow	: uint		: Row number in field			*/
/*  (returns)	: KBCtrlRichText:					*/

KBCtrlRichText::KBCtrlRichText
	(	KBDisplay	*display,
		KBRichText	*richText,
		uint		drow
	)
	:
	QTextView	(display->getDisplayWidget()),
	KBControl	(this, display, richText, drow),
	richText	(richText)
{
	setTextFormat	(Qt::RichText) ;
}

/*  KBCtrlRichText								*/
/*  ~KBCtrlRichText: Desctructor for field class				*/
/*  (returns)	:		:					*/

KBCtrlRichText::~KBCtrlRichText ()
{
}

/*  KBCtrlRichText								*/
/*  showName	: Show control name					*/
/*  (returns)	: void		:					*/

void	KBCtrlRichText::showName ()
{
#if	! __KB_RUNTIME
	if ((m_drow == 0) && (m_showing == KB::ShowAsDesign))
		setText (richText->getName()) ;
#endif
}

/*  KBCtrlRichText								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCtrlRichText::showAs
	(	KB::ShowAs	mode
	)
{
	KBControl::showAs (mode) ;

#if	! __KB_RUNTIME
	if (mode == KB::ShowAsDesign)
	{
		if (m_drow == 0) showName () ;
		setCursor (QCursor(Qt::arrowCursor)) ;
		return ;
	}
#endif

	setCursor (QCursor(Qt::ibeamCursor)) ;
	setText   ("") ;
}

/*  KBCtrlRichText								*/
/*  setValue	: Set field value					*/
/*  value	: const KBValue &: Value				*/
/*  (returns)	: void		 :					*/

void	KBCtrlRichText::setValue
	(	const KBValue	&value
	)
{
	setText (value.getRawText()) ;
	KBControl::setValue  (value) ;
}

/*  KBCtrlRichText								*/
/*  getValue	: Get field value					*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBCtrlRichText::getValue ()
{
	/* If the control is empty and the initial value was null (as	*/
	/* opposed to an empty string), then return a null string.	*/
	if (text().isEmpty() && getIniValue().isNull())
		return	KBValue (richText->getFieldType()) ;

	return	KBValue (text(), richText->getFieldType()) ;
}

/*  KBCtrlRichText								*/
/*  clearValue	: Clear value for specified query and display row	*/
/*  query	: bool		: Clearing for query			*/
/*  (returns)	: void		:					*/

void	KBCtrlRichText::clearValue
	(	bool	query
	)
{
	setText ("") ;
	KBControl::clearValue (query) ;
}

/*  KBCtrlRichText								*/
/*  changed	: Test if field value has been changed			*/
/*  (returns)	: bool		: TRUE if changed			*/

bool	KBCtrlRichText::changed ()
{
	/* Special case: This handles the situation where the inital	*/
	/* value is null, otherwise we get empty != null.		*/
	if (text().isEmpty() && getIniValue().getRawText().isEmpty())
		return false ;

	return	text() != getIniValue().getRawText() ;
}

/*  KBCtrlRichText								*/
/*  isEmpty	: See if control is empty				*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlRichText::isEmpty ()
{
	return	text().isEmpty() ;
}

/*  KBCtrlRichText							*/
/*  giveFocus	: Give focus to the control				*/
/*  (returns)	: void							*/

void	KBCtrlRichText::giveFocus ()
{
	QTextView::setFocus () ;
}

/*  KBCtrlRichText							*/
/*  mainWidget	: Get the main widget for the control			*/
/*  (returns)	: QWidget *	: Widget in question			*/

QWidget	*KBCtrlRichText::mainWidget ()
{
	return	viewport () ;
}

/*  KBCtrlRichText								*/
/*  write	: Write field 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: Field area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  extra	: int &		: Return extra space			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlRichText::write
	(	KBWriter	*writer,
		QRect		rect,
		const KBValue	&value,
		bool		fSubs,
		int		&extra
	)
{
	if (writer->asReport())
	{
		KBWriterText *w = new KBWriterText
				  (	writer,
					rect,
					richText->getPalette(true),
					richText->getFont   (true),
					value.getRawText    (),
					0x1001,
					fSubs
				  )	;
		extra	= w->extra()	;
		return	true ;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
}
