/***************************************************************************
    file	         : kb_qtrowmark.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>

#if		__KB_EMBEDDED
#include	<qpe/qpeapplication.h>
#endif


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_rowmark.h"
#include	"kb_display.h"
#include	"kb_writer.h"
#include	"kb_qtrowmark.h"
#include	"kb_queryset.h"
#include	"kb_formblock.h"

#include	"tk_icons.h"



/*  KBCtrlRowMark								*/
/*  KBCtrlRowMark: Constructor for marker widget			*/
/*  display	 : KBDisplay *	: Parent display			*/
/*  rowmark	 : KBRowMark *	: Parent row marker			*/
/*  drow	 : uint		: Row number in marker			*/
/*  (returns)	 : KBCtrlRowMark:					*/

KBCtrlRowMark::KBCtrlRowMark
	(	KBDisplay	 *display,
		KBRowMark	 *rowmark,
		uint	 	 drow
	)
	:
	QLabel	  (display->getDisplayWidget ()),
	KBControl (this, display, rowmark, drow),
	m_rowmark (rowmark)
{
#if	__KB_EMBEDDED
	QPEApplication::setStylusOperation
	(	this,
		QPEApplication::RightOnHold
	)	;
#endif
	m_current = false	 ;
	m_inBlock = false	 ;
	m_state	  = KB::RSInSync ;

	setAlignment (Qt::AlignRight|Qt::AlignTop) ;

	m_showRow = m_rowmark->getShowRow() ;
	redraw	() ;
}

/*  KBCtrlRowMark							*/
/*  ~KBCtrlRowMark: Destructor for marker widget			*/
/*  (returns)	  :		:					*/

KBCtrlRowMark::~KBCtrlRowMark ()
{
}

/*  KBCtrlRowMark							*/
/*  eventFilter	: Widget event filter					*/
/*  o		: QObject *	: Object originating event		*/
/*  e		: QEvent *	: Event in question			*/
/*  (returns)	: bool		: False to continue processing		*/

bool	KBCtrlRowMark::eventFilter
	(	QObject	*o,
		QEvent	*e
	)
{
	if (e->type() == QEvent::MouseButtonDblClick)
	{
		m_rowmark->doubleClick (m_rowmark->getBlock()->getCurDRow() + m_drow) ;
		return	true	;
	}

	if (e->type() == QEvent::MouseButtonPress)
		if (m_current && (m_showing == KB::ShowAsData))
		{
			QMouseEvent *me      = (QMouseEvent *)e ;
			uint	    qrow     = m_rowmark->getBlock()->getCurDRow() + m_drow ;
			KB::MarkOp  op	     ;

			if	(me->state() & QMouseEvent::ControlButton)
				op = KB::MarkOpToggle ;
			else if	(me->state() & QMouseEvent::ShiftButton  )
				op = KB::MarkOpRange  ;
			else
				op = KB::MarkOpSet    ;

			m_rowmark->setRowMarked (qrow, op) ;
		}

	return	KBControl::eventFilter (o, e) ;
}

/*  KBCtrlRowMark							*/
/*  redraw	: Redraw to get profile and frame correct		*/
/*  (returns)	: bool		:					*/

void	KBCtrlRowMark::redraw ()
{
	ctrlSetFrame (this) ;
}

/*  KBCtrlRowMark							*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCtrlRowMark::showAs
	(	KB::ShowAs	mode
	)
{
	KBControl::showAs (mode) ;

	if (mode == KB::ShowAsData)
	{
		m_showRow = m_rowmark->getShowRow() ;
		m_rowNo	  = 0x7fffffff		;
		return	  ;
	}

	m_rowNo	= 0 ;
	setText	(m_showRow ? QString("%1").arg(m_drow) : QString::null) ;
}

/*  KBCtrlRowMark							*/
/*  showIcon	: Show icon appropriate to the state			*/
/*  (returns)	: void		:					*/

void	KBCtrlRowMark::showIcon ()
{
	if (m_current)
	{
		if (m_inBlock)
			setPixmap (getSmallIcon("current")) ;
		else	setPixmap (getSmallIcon("elsewhere")) ;

		return	;
	}

	switch (m_state)
	{
		case KB::RSDeleted  :
			setPixmap (getSmallIcon("removed" )) ;
			break	;

		case KB::RSChanged  :
			setPixmap (getSmallIcon("changed" )) ;
			break	;

		case KB::RSInserted :
			setPixmap (getSmallIcon("inserted")) ;
			break	;

		default	:
			setText	  (m_showRow ?
					QString("%1").arg(m_rowNo + 1) :
					QString("")
				  )	;
			break	;
	}
}

/*  KBCtrlRowMark								*/
/*  setData	: Set state or current status				*/
/*  _data	: void *	: Actually KBRowMarkData *		*/
/*  (returns)	: void		:					*/

void	KBCtrlRowMark::setData
	(	void	*_data
	)
{
	KBRowMarkData	*data	= (KBRowMarkData *)_data ;

	switch (data->type)
	{
		case KBRowMarkData::State   :
			if (data->state   != m_state)
			{	m_state	  = data->state	  ;
				showIcon  () ;
			}
			break	;

		case KBRowMarkData::Current :
			if (data->current != m_current)
			{	m_current = data->current ;
				showIcon  ()	;
			}
			break	;

		case KBRowMarkData::InBlock :
			if (data->inBlock != m_inBlock)
			{	m_inBlock = data->inBlock ;
				showIcon  ()	;
			}
			break	;

		case KBRowMarkData::RowNo   :
			if (data->rowNo   != m_rowNo)
			{	m_rowNo	  = data->rowNo	  ;
				showIcon  ()	;
			}
			break	;

		default	:
			break	;
	}
}

/*  KBCtrlRowMark							*/
/*  clearValue	: Clear value						*/
/*  query	: bool		: Clear for query			*/
/*  (returns)	: void		:					*/

void	KBCtrlRowMark::clearValue
	(	bool
	)
{
	m_state	= KB::RSInSync ;
	showIcon ()    ;
}

/*  KBCtrlRowMark								*/
/*  giveFocus	: Give focus to the control				*/
/*  (returns)	: void							*/

void	KBCtrlRowMark::giveFocus ()
{
	QWidget::setFocus () ;
}

/*  KBCtrlRowMark								*/
/*  write	: Write row mark 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: Field area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  extra	: int &		: Return extra space			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlRowMark::write
	(	KBWriter	*writer,
		QRect		rect,
		const KBValue	&value,
		bool		fSubs,
		int		&extra
	)
{
	if (writer->asReport())
	{
		extra	= 0	;
		return	true	;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
}
