/***************************************************************************
    file	         : kb_qtspinbox.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QTSPINBOX_H
#define	_KB_QTSPINBOX_H

#include	<qspinbox.h>

#include	"kb_ctrl.h"
#include	"kb_mask.h"

#include	"libkbase_exports.h"

#define	NOCHANGE(s)	\
	{	m_inSetValue = true  ;	\
		s ;			\
		m_inSetValue = false ;	\
	}

class	KBSpinBox	;

/*  KBCtrlSpinBox							*/
/*  -------------							*/
/*  Wrapper class for spin box control					*/

class	LIBKBASE_API	KBCtrlSpinBox : public QSpinBox, public KBControl
{
	Q_OBJECT

	KBSpinBox	*m_spinbox	;
	QWidget		*m_mainWidget	;

	bool		m_inSetValue	;
	bool		m_isNull	;

protected slots :

	void			slotValueChanged(const QString &);

protected :

        virtual void    	giveFocus	()	;
	virtual	void		focusInEvent	(QFocusEvent  *) ;
	virtual	void		focusOutEvent	(QFocusEvent  *) ;
	virtual	QString		mapValueToText	(int)	;

public	:

	KBCtrlSpinBox (KBDisplay *, KBSpinBox *, uint) ;
virtual~KBCtrlSpinBox () ;

	virtual	QWidget		*mainWidget	() ;
	virtual	void		showName	() ;
	virtual	void		showAs		(KB::ShowAs) ;
	virtual	void		setValue	(const KBValue &) ;
	virtual	KBValue		getValue	() ;
	virtual	void		clearValue	(bool) ;
	virtual	bool		changed		() ;
	virtual	bool		isEmpty		() ;
	virtual	bool		isValid		(bool) ;
	virtual	bool		write		(KBWriter *, QRect, const KBValue &, bool, int &) ;

	virtual	QString		morphText	() ;

	SETFOCUS
	SIZEHINT
}	;


#endif	// _KB_QTSPINBOX_H
