/***************************************************************************
    file	         : kb_slotdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_SLOTDLG_H
#define	__KB_SLOTDLG_H


#include	<qcombobox.h>
#include	<qpushbutton.h>
#include	<qlabel.h>
#include	<qcheckbox.h>
#include	<qlistbox.h>

#include	"kb_classes.h"
#include	"kb_dialog.h"
#include	"kb_slot.h"

#include	"tktextmanager.h"
#include	"tktexteditor.h"
#include	"tkc_tkemapper.h"

#include	"tk_lineedit.h"


class	KBSlotLinkItem	;


/*  KBSlotDlg								*/
/*  ---------								*/
/*  This dialog is used to manipulate a particular slot.		*/

class	LIBKBASE_API	KBSlotDlg : public _KBDialog
{
	Q_OBJECT

	KBSlot		*m_slot		;
	KBObject	*m_parent	;

	QLabel		m_lSlotName	;
	QLabel		m_lLinkPicker	;
	QLabel		m_lLinkName	;
	QLabel		m_lLinkTarget	;
	QLabel		m_lLinkEvent	;
	QLabel		m_lLinkEnabled	;
	TKLineEdit	m_eSlotName	;
	QComboBox	m_cLinkPicker	;
	TKLineEdit	m_eLinkName	;
	TKLineEdit	m_eLinkTarget	;
	TKLineEdit	m_eLinkEvent	;
	QCheckBox	m_cLinkEnabled	;
	QPushButton	m_bFind		;
	QPushButton	m_bAddLink	;
	QPushButton	m_bEditLink	;
	QPushButton	m_bDismissLink	;
	QPushButton	m_bSaveLink	;
	QPushButton	m_bDropLink	;
	TKTextEditor	m_tkEditor	;
	TKCTKEMapper	m_mapper	;
	QPushButton	m_bVerify	;
	QPushButton	m_bOK		;
	QPushButton	m_bCancel	;

	KBSlotLinkItem	*m_currentItem	;
	bool		m_changed	;

protected slots :

	void		clickFind	()	;
	void		clickAdd	()	;
	void		clickEdit	()	;
	void		clickSave	()	;
	void		clickDismiss	()	;
	void		clickDrop	()	;
	void		clickVerify	()	;
	void		clickOK		()	;
	void		clickCancel	()	;
	void		linkSelected	(int)	;

public	:

	KBSlotDlg	(KBSlot	*, KBObject *)	;
}	;



/*  KBSlotListDlg							*/
/*  -------------							*/
/*  This dialog (which is actually derived from a QWidget and is	*/
/*  intended to be embedded in a real dialog) is used to select amongst	*/
/*  a list of slots.							*/

class	LIBKBASE_API	KBSlotListDlg : public QWidget
{
	Q_OBJECT

	KBObject	*m_object	;

	QListBox	m_lbSlotList	;
	QPushButton	m_bAddSlot	;
	QPushButton	m_bEditSlot	;
	QPushButton	m_bDropSlot	;

protected slots :

	void	clickAddSlot	()	;
	void	clickEditSlot	()	;
	void	clickDropSlot	()	;
	void	highlighted	()	;

public	:

	KBSlotListDlg	(QWidget *, QList<KBSlot> &, KBObject *) ;

	void	save	(QList<KBSlot> &) ;
}	;


#endif	// __KB_SLOTDLG_H
