/***************************************************************************
    file	         : kb_taborddlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_TABORDDLG_H
#define	_KB_TABORDDLG_H

#if	! __KB_RUNTIME

#include	<qlist.h>
#include	<qlistbox.h>
#include	<qpushbutton.h>
#include	<qspinbox.h>
#include	<qlabel.h>
#include	<qlayout.h>

#include	"kb_classes.h"
#include	"kb_dialog.h"
#include	"kb_block.h"
#include	"kb_draglist.h"

#include	"libkbase_exports.h"

LIBKBASE_API enum 	Order
{
	byTabOrder,
	byColumn,
	byRow
}	;


/*  KBTabOrderObject							*/
/*  ----------------							*/
/*  Prior to by column or by row ordering, each KBObject is associated	*/
/*  with a pair of KBTabOrderObject's (via the KBTabListObject class	*/
/*  below). These are used to group such items by X- and Y- proximity,	*/
/*  so that ordering can treat similar X and similar Y values as the	*/
/*  same.								*/

class	LIBKBASE_API	KBTabOrderObject
{
	uint	m_minval	;
	uint	m_maxval	;

public	:

	inline	KBTabOrderObject
		(	uint	val
		)
		:
		m_minval (val),
		m_maxval (val)
	{
	}

	bool	objectInRange (KBObject *, char axis, uint) ;

	inline	uint	getOrderVal ()
	{
		return	m_minval ;
	}
}	;


/*  KBTabListObject							*/
/*  ---------------							*/
/*  In order to manage the order by column and order by row functions,	*/
/*  each KBObject has an associated KBTabListObject (not to be confused	*/
/*  with KBTabListBoxObject below). This contains pointers at the	*/
/*  KBObject, at the x- and y- ordering objects, and a pointer at the	*/
/*  variable which indicates the required sorting order.		*/

class	LIBKBASE_API	KBTabListObject
{
	KBObject		*m_object	;
	KBTabOrderObject	*m_orderx	;
	KBTabOrderObject	*m_ordery	;
	Order			*m_order	;
	bool			m_tabbed	;

public	:

	KBTabListObject	   (KBObject *, Order *) ;

	void	coalesce   (QList<KBTabOrderObject> &, QList<KBTabOrderObject> &, uint) ;
	int	comparedTo (KBTabListObject *) ;

	inline	KBObject*getObject ()
	{
		return	m_object ;
	}

	inline	bool	getTabbed ()
	{
		return	m_tabbed ;
	}

	inline	void	setTabbed
		(	bool	tabbed
		)
	{
		m_tabbed = tabbed ;
	}
}	;


/*  KBTabList								*/
/*  ---------								*/
/*  This is simply a list of KBTabListObject's, and provides a sorting	*/
/*  function, used when the user requests order by column or order by	*/
/*  row.								*/

class	LIBKBASE_API	KBTabList : public QList<KBTabListObject>
{
protected :

	virtual	int compareItems (QCollection::Item, QCollection::Item) ;
}	;


/*  KBTabListBoxObject							*/
/*  ------------------							*/
/*  This class is a wrapper round QListBoxText. It retains a pointer	*/
/*  at the KBObject with which it is associated, and has a method via	*/
/*  which the tab order value of the KBObject can be set.			*/

class	LIBKBASE_API	KBTabListBoxObject : public QListBoxText
{
	KBTabListObject	*m_object	;

public	:

	KBTabListBoxObject (QListBox *, KBTabListObject *) ;

	inline	KBTabListObject	*getObject ()
	{
		return	m_object	;
	}
}	;


/*  KBTabOrderDlg							*/
/*  -------------							*/
/*  Class for dialog used for general purpose tab ordering.		*/

class	LIBKBASE_API	KBTabOrderDlg : public _KBDialog
{
	Q_OBJECT

	KBBlock			*m_block	;
	QList<KBObject>		&m_objects	;

	QHBoxLayout		*m_layMain	;
	QVBoxLayout		*m_layAddRem	;

#if	! __KB_EMBEDDED
	QGridLayout		*m_layRight	;
#endif

	KBDragBox		m_lObjects	;
	QListBox		m_xObjects	;
	QPushButton		m_bOK		;
	QPushButton		m_bCancel	;
	QPushButton		m_bAdd		;
	QPushButton		m_bRemove	;

#if	! __KB_EMBEDDED
	QPushButton		m_bByColumn	;
	QPushButton		m_bByRow	;
	QLabel			m_lTolerance	;
	QSpinBox		m_sTolerance	;
#endif
#if	! __KB_EMBEDDED && ! __KB_TKC
	QPushButton		m_bHelp		;
#endif

	QPushButton		m_bMoveUp	;
	QPushButton		m_bMoveDown	;

	Order			m_order		;

	KBTabList		m_tabList	;
	QList<KBTabOrderObject>	m_orderx	;
	QList<KBTabOrderObject>	m_ordery	;

	void		loadListBox ()		;
#if	! __KB_EMBEDDED
	void		positionSort(Order)	;
#endif

public	:

	KBTabOrderDlg (KBBlock *, QList<KBObject> &) ;

public	slots :

	void	clickOK		() ;
	void	clickCancel	() ;
	void	clickAdd	() ;
	void	clickRemove	() ;
	void	clickByRow	() ;
	void	clickByColumn	() ;
	void	clickHelp	() ;
	void	clickMoveUp	() ;
	void	clickMoveDown	() ;
	void	highlighted	(int) ;
}	;

#endif
#endif	// _KB_TABORDDLG_H
