/***************************************************************************
    file	         : tk_helpproxy.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TK_HELPPROXY_H
#define	__TK_HELPPROXY_H

#include	<qstring.h>
#include	<qobject.h>

#if		__KB_KDE
#include	<kprocess.h>
#endif

#include	"libkbase_exports.h"

class LIBKBASE_API	KProcess	;

/*  TKHelpRequest							*/
/*  -------------							*/
/*  This structure is used to pass data to the help display process.	*/
/*  The fields are the name of the help page and the legend which is	*/
/*  the text for the tab.						*/

struct LIBKBASE_API	TKHelpRequest
{	
	char	page	[256]	;
}	;


class LIBKBASE_API	TKHelpProxy : public QObject
{
	Q_OBJECT

#if	__KB_KDE
	KProcess	process		;
#endif
	QString		helpDir		;

protected slots :

	void		processExited	(KProcess *)	;

public	:

	TKHelpProxy	()	;

	bool		helpPageExists	(const QString &) ;
	void		showHelpPage	(const QString &) ;

	static		TKHelpProxy	*self() ;
}	;

#endif	// __TK_HELPPROXY_H
