/***************************************************************************
    file	         : kb_attralign.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_ATTRALIGN_H
#define	__KB_ATTRALIGN_H

#include	"libkbase_exports.h"
#include	"kb_attr.h"

#if		! __KB_RUNTIME
#include	"kb_attritem.h"
#endif

/*  KBAttrAlign								*/
/*  -----------								*/
/*  This class handles attributes which describe alignment. The basic	*/
/*  case is horizontal/vertical, while for KBLabel we also allow rich	*/
/*  text as an option.							*/

class	LIBKBASE_API	KBAttrAlign : public KBAttrInt
{
public	:

	KBATTRCTRDEF (KBAttrAlign, KBAttrInt)
	KBATTRINTDEF (KBAttrAlign, KBAttrInt)

	virtual	KBAttr		*replicate	(KBNode  * ) ;

#if	! __KB_RUNTIME
	virtual	KBAttrDlg	*getAttrDlg
				(	QWidget			*,
					KBAttrItem		*,
					QDict<KBAttrItem>	&
				)	;
	virtual	QString		displayValue	(const QString &) ;
#endif
}	;

#define	RICHTEXT	0x1001

#if	QT_VERSION >= 300
#define	Horizontal_Mask	(Qt::AlignHorizontal_Mask)
#define	Vertical_Mask	(Qt::AlignVertical_Mask)
#else
#define	Horizontal_Mask	(Qt::AlignLeft|Qt::AlignHCenter|Qt::AlignRight )
#define	Vertical_Mask	(Qt::AlignTop |Qt::AlignVCenter|Qt::AlignBottom)
#endif

#endif	// __KB_ATTRALIGN_H
