/***************************************************************************
    file	         : kb_attrframedlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>

#include	"kb_classes.h"
#include	"kb_attr.h"
#include	"kb_attrframe.h"
#include	"kb_node.h"


#ifndef 	_WIN32
#include 	"kb_attrframedlg.moc"
#else
#include 	"kb_attrframedlg.h"
#endif



/*  KBAttrFrameDlg							*/
/*  KBAttrFrameDlg							*/
/*		: Constructor for alignment dialog			*/
/*  parent	: QWidget *		: Parent widget			*/
/*  attr	: KBAttr *		: Associated attribute		*/
/*  item	: KBAttrItem *		: Associated item		*/
/*  attrDict	: QDict<KBAttrItem> &	: Attribute dictionary		*/
/*  (returns)	: KBAttrFrameDlg	:				*/

KBAttrFrameDlg::KBAttrFrameDlg
	(	QWidget			*parent,
		KBAttr			*attr,
		KBAttrItem		*item,
		QDict<KBAttrItem>	&attrDict
	)
	:
	KBAttrDlg	(parent, attr, item, attrDict),
	m_lShadow	(this),
	m_lShape	(this),
	m_lWidth	(this),
	m_cShadow	(this),
	m_cShape	(this),
	m_sWidth	(this),
	m_sample	(this)
{
	QHBoxLayout	*layMain = new QHBoxLayout (this)    ;
	QGridLayout	*layGrid = new QGridLayout (layMain) ;

	layMain->addWidget (&m_sample) ;
	layGrid->addWidget (&m_lShadow, 0, 0) ;
	layGrid->addWidget (&m_lShape,  1, 0) ;
	layGrid->addWidget (&m_lWidth,  2, 0) ;
	layGrid->addWidget (&m_cShadow, 0, 1) ;
	layGrid->addWidget (&m_cShape,  1, 1) ;
	layGrid->addWidget (&m_sWidth,  2, 1) ;

	layGrid->setRowStretch (3, 1) ;

	m_lShadow.setText  (TR("Shadow")) ;
	m_lShape .setText  (TR("Shape" )) ;
	m_lWidth .setText  (TR("Width" )) ;

	m_sWidth .setRange (0, 8) ;
	m_sample .setMinimumSize (120, 120) ;
	m_sample .show	   ()	;

	connect	(&m_cShadow, SIGNAL(activated   (int)), this, SLOT(setFrame())) ;
	connect	(&m_cShape , SIGNAL(activated   (int)), this, SLOT(setFrame())) ;
	connect	(&m_sWidth , SIGNAL(valueChanged(int)), this, SLOT(setFrame())) ;
}

/*  KBAttrFrameDlg							*/
/*  init	: Initialise for editing				*/
/*  value	: const QString & : Value				*/
/*  (returns)	: bool		  : Always false, no modal dialog	*/

bool	KBAttrFrameDlg::init
	(	const QString	&value
	)
{
	int	style	= 0 ;
	int	width	= 0 ;
	int	coff	= value.find  (',') ;

	/* Note: The backround colour property will not exist if the	*/
	/*	 entire display area inside the frame is occupied,	*/
	/*	 for example in a memo					*/
	QString	   bgcolor = getAttrVal ("bgcolor") ;

	if (coff >= 0)
	{	style	= value.left(coff    ).toInt() ;
		width	= value.mid (coff + 1).toInt() ;
	}

	m_cShadow.clear () ;
	m_cShape .clear () ;

	KBAttrItem::showChoices (KBAttrFrame::getChoiceShadow(), QString("%1").arg(style & QFrame::MShadow), &m_cShadow) ;
	KBAttrItem::showChoices (KBAttrFrame::getChoiceShape (), QString("%1").arg(style & QFrame::MShape ), &m_cShape ) ;
	m_sWidth.setValue (width) ;

	m_sample.setFrameStyle (style) ;
	m_sample.setLineWidth  (width) ;

	QPalette pal = QApplication::palette() ;
	if (!bgcolor.isEmpty())
	{	const QColor bg = QColor (QRgb(strtol(bgcolor,0,0))) ;
		pal.setColor (QColorGroup::Base,       bg) ;
		pal.setColor (QColorGroup::Button,     bg) ;
		pal.setColor (QColorGroup::Background, bg) ;
	}
	m_sample.setPalette (pal) ;

	return	false	;
}

/*  KBAttrFrameDlg							*/
/*  value	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBAttrFrameDlg::value ()
{
	int	shadow	= KBAttrFrame::getChoiceShadow()[m_cShadow.currentItem()].value ;
	int	shape	= KBAttrFrame::getChoiceShape ()[m_cShape .currentItem()].value ;
	int	width	= m_sWidth.value () ;

	return	QString("%1,%2").arg(shadow|shape).arg(width) ;
}

void	KBAttrFrameDlg::setFrame ()
{
	int	shadow	= KBAttrFrame::getChoiceShadow()[m_cShadow.currentItem()].value ;
	int	shape	= KBAttrFrame::getChoiceShape ()[m_cShape .currentItem()].value ;
	int	width	= m_sWidth.value () ;

	m_sample.setFrameStyle (shadow|shape) ;
	m_sample.setLineWidth  (width) ;
}
