/***************************************************************************
    file	         : kb_checkbox.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_object.h"
#include	"kb_navigator.h"

#ifndef		_WIN32
#include	"kb_checkbox.moc"
#else
#include	"kb_checkbox.h"
#endif

/*  KBCheckBox								*/
/*  KBCheckBox	: Constructor for local checkbox wrapper		*/
/*  parent	: QWidget *	: Parent widget				*/
/*  name	: const char *	: Object name				*/
/*  (returns)	: KBCheckBox	:					*/

KBCheckBox::KBCheckBox
	(	QWidget		*parent,
		const char	*name
	)
	:
	QCheckBox (parent, name)
{
	m_readOnly = false ;
}

/*  KBCheckBox								*/
/*  setReadOnly	: Set read-only state					*/
/*  readOnly	: bool		: State					*/
/*  (returns)	: void		:					*/

void	KBCheckBox::setReadOnly
	(	bool		readOnly
	)
{
	m_readOnly = readOnly ;
}

/*  KBCheckBox								*/
/*  event	: Event handler						*/
/*  e		: QEvent *	: Event received			*/
/*  (returns)	: bool		: Event consumed			*/

bool	KBCheckBox::event
	(	QEvent		*e
	)
{
	if (m_readOnly)
		switch (e->type())
		{
			case QEvent::MouseButtonPress	:
			case QEvent::MouseButtonRelease :
			case QEvent::MouseButtonDblClick:
				return	true	;

			case QEvent::KeyPress		:
			case QEvent::KeyRelease		:
				if (!KBNavigator::isNavKey ((QKeyEvent *)e))
					return	true	;
				break	;

			default	:
				break	;
		}

	return	QCheckBox::event (e) ;
}
