/***************************************************************************
    file	         : kb_component.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef		_WIN32
#include	"kb_component.moc"
#else
#include	"kb_component.h"
#endif

#include	"kb_param.h"
#include	"kb_display.h"
#include	"kb_sizer.h"
#include	"kb_formcopier.h"
#include	"kb_nodereg.h"
#include	"kb_popupmenu.h"
#include	"kb_qrynull.h"


/*  KBComponent								*/
/*  KBComponent	: Constructor for form root class for extant component	*/
/*  location	: KBLocation &	 : Form location			*/
/*  aList	: const QDict<QString> &				*/
/*				 : List of attributes			*/
/*  (returns)	: KBComponent	 :					*/

KBComponent::KBComponent
	(	KBLocation		&location,
		const QDict<QString>	&aList
	)
	:
	KBBlock     (0,     aList,	   "KBComponent"),
	KBNavigator (this,   0,		   children),
	KBLayout    (this),
	m_type	    (this,  "type",    	   aList,	KF_REQD),
	m_language  (this,  "language",	   aList,	KF_REQD),
	m_docRoot   (this,  children,      location)
{
	root	     = this ;
	m_display    = 0    ;

	dx.setValue  ( 0)   ;
	dy.setValue  (20)   ;

	blkType	= BTNull	;
	new KBQryNull (this)	;

	switch (objType())
	{
		case KB::ObjForm :
			KBNode::flags	|= KF_FORM   ;
			break	;

		case KB::ObjReport :
			KBNode::flags	|= KF_REPORT ;
			break	;

		default	:
			break	;
	}

	DELOBJ	(m_attrConfig)	;
}


/*  KBComponent								*/
/*  KBComponent	: Constructor for form root class for new form		*/
/*  location	: KBLocation &	 : Form location			*/
/*  aList	: const QDict<QString> &				*/
/*				 : List of attributes			*/
/*  _ok		: bool &	 : Success				*/
/*  (returns)	: KBComponent	 :					*/

KBComponent::KBComponent
	(	KBLocation		&location,
		const QDict<QString>	&aList,
		bool			&_ok
	)
	:
	KBBlock     (0,     aList,	   "KBComponent"),
	KBNavigator (this,   0,		   children),
	KBLayout    (this),
	m_type	    (this,  "type",        aList,	KF_REQD),
	m_language  (this,  "language",	   aList,	KF_REQD),
	m_docRoot   (this,  children, 	   location)
{
	root	     = this ;
	m_display    = 0    ;

	if (!propertyDlg  (0))
	{	_ok	= false ;
		return	;
	}

	blkType	= BTNull ;
	new KBQryNull (this) ;

	switch (objType())
	{
		case KB::ObjForm :
			KBNode::flags	|= KF_FORM   ;
			break	;

		case KB::ObjReport :
			KBNode::flags	|= KF_REPORT ;
			break	;

		default	:
			break	;
	}

	_ok	= true	;
	KBLayout::setChanged() ;

	dx.setValue  ( 0)   ;
	dy.setValue  (20)   ;

	DELOBJ	(m_attrConfig) ;
}

/*  KBComponent								*/
/*  KBComponent	: Component replication constructor			*/
/*  _parent	: KBNode *	: Parent element			*/
/*  _extant	: KBComponent *	: Extant component			*/
/*  (returns)	: KBComponent	:					*/

KBComponent::KBComponent
	(	KBNode		*_parent,
		KBComponent	*_extant
	)
	:
	KBBlock     (_parent, 		_extant ),
	KBNavigator (this,   0,		children),
	KBLayout    (this),
	m_type	    (this,  "type",     _extant, KF_REQD),  
	m_language  (this,  "language",	_extant, KF_REQD),
	m_docRoot   (this,  children, 	_extant->getDocRoot()->getLocation())
{
	root	     = this ;
	m_display    = 0    ;

	dx.setValue  ( 0)   ;
	dy.setValue  (20)   ;

	DELOBJ	(m_attrConfig) ;
}

/*  KBComponent								*/
/*  ~KBComponent	: Destructor for form root class			*/
/*  (returns)	:		:					*/

KBComponent::~KBComponent ()
{
	showMonitor ((QListView *)0) ;
}

/*  KBComponent								*/
/*  printNode	: Output node XML					*/
/*  text	: QString &	: Resulting text			*/
/*  indent	: int		: Indent level of this node		*/
/*  (returns)	: void		:					*/

void	KBComponent::printNode
	(	QString	&text,
		int	indent
	)
{
	/* Implement this specially, since we need to output the XML	*/
	/* header. Also output script stuff and paramaters near the	*/
	/* front.							*/
	extern	QString	kbXMLEncoding  () ;
	QString		nodeText ;

	text	+= QString
		   (	"<?xml version=\"1.0\" encoding=\"%1\"?>\n"
			"<!DOCTYPE KBaseComponent SYSTEM \"kbasecomponent.dtd\">\n"
		   )
		   .arg	(kbXMLEncoding()) ;

	text	+= QString("%1<%2").arg("", indent).arg(getElement()) ;
	for (uint idx = 0 ; idx < attribs .count () ; idx += 1)
		attribs.at(idx)->printAttr(text, nodeText, indent + 2) ;
	text	+= ">\n" ;

	/* Print the child nodes, except that we skip the dummy null	*/
	/* query node.							*/
	LITER
	(	KBNode,
		children,
		n,
		if (n->isQryBase() == 0)
			n->printNode (text, indent+2)  ;
	)

	text	+= nodeText ;
	text	+= QString("%1</%2>\n").arg("", indent).arg(getElement()) ;
}

#if	! __KB_RUNTIME

/*  KBComponent								*/
/*  showDesign	: Show form in design mode				*/
/*  parent	: QWidget *	  : Parent widget			*/
/*  size	: QSize &	  : Return required size		*/
/*  (returns)	: KB::ShowRC	  : Startup return code			*/

KB::ShowRC
	KBComponent::showDesign
	(	QWidget		*parent,
		QSize		&size
	)
{
	/* Start with the block setup. This links blocks to queries and	*/
	/* such. Any error here is a real problem.			*/
	if (!blockSetup ())
		return	KB::ShowRCError  ;

	/* If this is the first time the form is displayed, create the	*/
	/* top-level display and build the form GUI.			*/
	if (m_display == 0)
	{
		m_display = new KBDisplay
			    (	parent,
				this,
				false,
				false
			    )	;

		buildTopDisplay (m_display) ;
		buildCtrls      (0, 0, 0) ;
	}

	KBLayout::clear      (true)  ;
	KBLayout::initSizer  ()	;
	KBBlock ::showAs     (KB::ShowAsDesign) ;

	QScrollView *scroller = m_display->getScroller ()      ;
	size	= m_display->getSizeNeeded (geometry().size()) ;

	scroller->resizeContents (1600, 1600) ;
	size	+= QSize (100, 100) ;

	setSizer (new KBSizer
			(	this, 
				m_display,
				m_display->getDisplayWidget()
		 )	) ;

	return	KB::ShowRCDesign ;
}

/*  KBComponent								*/
/*  showData	: Show component in data mode				*/
/*  parent	: QWidget *	  : Parent widget			*/
/*  size	: QSize &	  : Return required size		*/
/*  (returns)	: KB::ShowRC	  : Startup return code			*/

KB::ShowRC
	KBComponent::showData
	(	QWidget		*parent,
		QSize		&size
	)
{
	/* Start with the block setup. This links blocks to queries and	*/
	/* such. Any error here is a real problem.			*/
	if (!blockSetup ())
		return	KB::ShowRCError  ;

	/* If this is the first time the form is displayed, create the	*/
	/* top-level display and build the form GUI.			*/
	if (m_display == 0)
	{
		m_display = new KBDisplay
			    (	parent,
				this,
				false,
				false
			    )	;

		buildTopDisplay (m_display) ;
		buildCtrls      (0, 0, 0) ;
	}

	KBLayout::clear      (true)  ;
	KBLayout::initSizer  ()	;
	KBBlock ::showAs     (KB::ShowAsData) ;

	QScrollView *scroller = m_display->getScroller ()      ;
	size	= m_display->getSizeNeeded (geometry().size()) ;

	scroller->resizeContents (size.width(), size.height()) ;

	return	KB::ShowRCData ;
}
#endif

/*  KBComponent								*/
/*  resize	: Resize the component					*/
/*  w		: int		: New width				*/
/*  h		: int		: New height				*/
/*  (returns)	: bool		: Size changed				*/

bool	KBComponent::resize
	(	int	_w,
		int	_h
	)
{
	if (KBObject::resize (_w, _h))
	{
		m_display->resize (_w, _h) ;
		return	true	;
	}

	return	false	;
}

#if	! __KB_RUNTIME

/*  KBComponent								*/
/*  makeNewPopup: Make a new-thingy popup menu for a framer		*/
/*  cancel	: bool		: Show cancel item			*/
/*  _rect	: QRect		: New object area			*/
/*  (returns)	: void		:					*/

KBPopupMenu
	*KBComponent::makeNewPopup
	(	bool	,
		QRect	_rect
	)
{
	extern	void 	makeReportMenu (QPopupMenu *, QObject *, uint) ;
	extern	void 	makeFormMenu   (QPopupMenu *, QObject *, uint) ;

	KBPopupMenu	*newPopup = new KBPopupMenu (0) ;

	switch (objType())
	{
		case KB::ObjForm	:
			newPopup->insertEntry
			(	false,
				TR("&Container"),
				this,
				SLOT(newContainer ())
			)	;
			newPopup->insertSeparator () ;
			makeFormMenu   (newPopup, this, KF_FRAMER|KF_STATIC|KF_DATA) ;
			break	;

		case KB::ObjReport	:
			makeReportMenu (newPopup, this, KF_FRAMER|KF_STATIC|KF_DATA) ;
			break	;

		default	:
			break	;
	}

	m_newRect = _rect	;
	return	newPopup	;
}

/*  KBComponent								*/
/*  designPopup	: Handle design menu request				*/
/*  e		: QMouseEvent *	: Associated mouse event		*/
/*  drow	: uint		: Display row				*/
/*  (returns)	: void		:					*/

void	KBComponent::designPopup
	(	QMouseEvent	*e,
		uint
	)
{
	KBPopupMenu popupMain	(0) ;
	KBPopupMenu *popupEdit	= new KBPopupMenu (0) ;
	KBPopupMenu *popupNew	= makeNewPopup (false, QRect()) ;

	KBNode	*dummy	;
	bool	noIns	= !KBFormCopier::self()->anyCopied(dummy) ;
	bool	noItem	= true	   ;
	CITER (Item, i, noItem = false ; break )

	popupEdit->insertEntry (noIns,  TR("&Paste objects"),  this, SLOT(pasteObjects	())) ;
	popupEdit->insertEntry (noIns,  TR("Paste &here"),     this, SLOT(pasteHere	())) ;
 	popupEdit->insertEntry (false,  TR("Paste component"), this, SLOT(pasteComponent())) ;
 	popupEdit->insertEntry (false,  TR("Link component"),  this, SLOT(linkComponent ())) ;

	popupMain .insertItem  (TR("Cancel")) ;
	popupMain .insertItem  (TR("&Edit"), popupEdit) ;
	popupMain .insertItem  (TR("&New"),  popupNew ) ;

	popupMain .insertItem
	(	TR("Component properties"),
		this,
		SLOT(propertyDlg ())
	)	;

//**	m_insertAt	= e->pos ()	 ;
//**	m_newRect	= QRect  ()	 ;
	insertAt	= e->pos ()	 ;
	newRect		= QRect  ()	 ;
	popupMain .exec	(QCursor::pos()) ;
}

/*  KBComponent								*/
/*  propertyDlg	: Run root property dialog				*/
/*  iniAttr	: cchar *	: Initial attribute			*/
/*  (returns)	: bool		: Success					*/

bool	KBComponent::propertyDlg
	(	cchar	*iniAttr
	)
{
	QList<KBParam > params  ;

	KBAttrStr	pattr	(this, "paramlist", "") ;

	CITER
	(	Param,
		p,
		params .append (p)
	)

	if (!::componentPropDlg (this, "Component", attribs, params, iniAttr))
		return false ;

	KBLayout::setChanged ()	;
	return	true	;
}

/*  KBComponent								*/
/*  newCtrlRect	: Get rectangle for new control				*/
/*  (returns)	: QRect		: Rectangle				*/

QRect	KBComponent::newCtrlRect ()
{
	return	m_newRect == QRect() ?
		getLayout()->newCtrlRect (this, (Qt::ButtonState)0, QRect (10, 10, 300, 200)) :
		m_newRect	;
}

/*  KBComponent								*/
/*  makeFramerPopup							*/
/*		: Make popup menu for a framer				*/
/*  framer	: KBFramer *	    : Framer in question		*/
/*  bState	: QT::ButtonState * : Button state return location	*/
/*  (returns)	: KBPopupMenu *	    : Popup menu			*/

KBPopupMenu
	*KBComponent::makeFramerPopup
	(	KBFramer	*framer,
		Qt::ButtonState	*bState
	)
{
	extern void 	makeFormMenu   (QPopupMenu *, QObject *, uint) ;
	extern void 	makeReportMenu (QPopupMenu *, QObject *, uint) ;

	switch	(objType())
	{
		case KB::ObjForm	:
		{
			KBPopupMenu	*newPopup = new KBPopupMenu (bState) ;

			newPopup->insertEntry     (false, TR("&Container"), framer, SLOT(newContainer())) ;
			makeFormMenu   (newPopup, framer, KF_FRAMER|KF_STATIC|KF_DATA) ;

			return	newPopup ;
		}

		case KB::ObjReport	:
		{
			KBPopupMenu	*newPopup = new KBPopupMenu (bState) ;

			makeReportMenu (newPopup, framer, KF_FRAMER|KF_STATIC|KF_DATA) ;
			return	newPopup ;
		}

		default	:
			break	;
	}

	return	0	;
}

#endif

/*  KBComponent								*/
/*  replicate	: Replicate this node					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: Replicated component			*/

KBNode	*KBComponent::replicate
	(	KBNode	*_parent
	)
{
	return	replicateBelow (new KBComponent (_parent, this)) ;
}

/*  KBComponent								*/
/*  newContainer : Add a new container					*/
/*  (returns)	 : void		:					*/

void	KBComponent::newContainer ()
{
#if	! __KB_RUNTIME
	QRect	   r	 = newCtrlRect () ;
	KBAttrDict cDict ;

	cDict.addValue ("x",	r.x     ()) ;
	cDict.addValue ("y",	r.y	()) ;
	cDict.addValue ("w",	r.width ()) ;
	cDict.addValue ("h",	r.height()) ;

	bool	 ok ;
	KBFramer *c = new KBContainer (this, cDict, "KBContainer", &ok) ;
	if (!ok) return ;

	c->buildDisplay (m_display) ;
	c->showAs   (KB::ShowAsDesign) ;
	c->getContainer()->show() ;
	getLayout()->setChanged() ;
#endif
}

/*  KBComponent								*/
/*  newNode	: Add a new node					*/
/*  id		: int		: Actually NodeSpec pointer for node	*/
/*  (returns)	: KBNode *	: The new node				*/

KBNode	*KBComponent::newNode
	(	int		id
	)
{
#if	! __KB_RUNTIME

	NodeSpec	*spec	= (NodeSpec *)id ;
	QRect		cRect	= newCtrlRect () ;
	KBAttrDict	aDict	(0) ;
	bool		ok	;
	KBNode		*node	;

	aDict.addValue ("x", 	    cRect.x     ()) ;
	aDict.addValue ("y", 	    cRect.y     ()) ;
	aDict.addValue ("w", 	    cRect.width ()) ;
	aDict.addValue ("h", 	    cRect.height()) ;

	aDict.addValue ("taborder", m_tabList.count () + 1) ;
	aDict.addValue ("align",    Qt::AlignLeft ) ;

	node	= spec->nodeFunc (this, aDict, &ok) ;

	if (!ok) return 0 ;

	KBObject *obj ;
	if ((obj = node->isObject()) != 0)
	{
		obj->buildDisplay (m_display) ;
		buildCtrls (0, 0, 0) ;

		if (obj->getTabOrder() > 0) m_tabList.append (obj) ;
	}

	node->showAs 	   (KB::ShowAsDesign) ;
	getLayout()->setChanged() ;

	fixTabOrder   () ;
	fixGridLayout () ;

	if (obj != 0)
		getLayout()->addSizer (obj->getSizer(), true) ;

	return	node	 ;
#else
	return	0	 ;
#endif
}

/*  KBComponent								*/
/*  pasteObjects: Paste in cut or copied objects			*/
/*  (returns)	: void		:					*/

void	KBComponent::pasteObjects ()
{
#if	! __KB_RUNTIME
	insertObjects (blkDisp) ;
#endif
}

/*  KBComponent								*/
/*  pasteHere	: Paste in cut or copied objects at specified position	*/
/*  (returns)	: void		:					*/

void	KBComponent::pasteHere ()
{
#if	! __KB_RUNTIME
	insertHere
	(	KBFormCopier::self()->getCopied (objType()),
		m_display,
		m_insertAt
	)	;
#endif
}

/*  KBComponent								*/
/*  pasteComponent							*/
/*		: Paste component object				*/
/*  (returns)	: void		:					*/

void	KBComponent::pasteComponent ()
{
#if	! __KB_RUNTIME
	insertComponent
	(	m_display,
		m_insertAt,
		m_newRect,
		true
	)	;
#endif
}

/*  KBComponent								*/
/*  linkComponent							*/
/*		: Link component object					*/
/*  (returns)	: void		:					*/

void	KBComponent::linkComponent ()
{
#if	! __KB_RUNTIME
	insertComponent
	(	m_display,
		m_insertAt,
		m_newRect,
		false
	)	;
#endif
}

/*  KBComponent								*/
/*  objType	: Get object type for this node				*/
/*  (returns)	: KB::ObjType	: Object type				*/

KB::ObjType KBComponent::objType ()
{
	return	(KB::ObjType)m_type.getIntValue() ;
}

KBValue	KBComponent::getValue
	(	uint
	)
{
	return	KBValue() ;
}

bool	KBComponent::setValue
	(	uint		,
		const KBValue	&
	)
{
	return	true	;
}

KBValue	*KBComponent::getBlockVal ()
{
	static	KBValue	dummy	;
	return	&dummy	;
}

uint	KBComponent::rowsInBlock ()
{
	return	1 ;
}

void	KBComponent::docPropDlg	()
{
}

