/***************************************************************************
    file	         : kb_copytable.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_COPYTABLE_H
#define	__KB_COPYTABLE_H

#include 	"libkbase_exports.h"

#include	<qstringlist.h>

#include	"kb_dom.h"
#include	"kb_location.h"
#include	"kb_dblink.h"
#include	"kb_database.h"


class	KBCopyCompare
{
	QStringList		m_keys	;
	uint			m_count	;

public	:

	inline	KBCopyCompare	()
	{
		m_count	= 0	;
	}

	inline	void	clear	()
	{
		m_count	= 0	;
		m_keys.clear()	;
	}

	inline	uint	count	()
	{
		return	m_count	;
	}

	void		addKey	(const QString &) ;
	QString		keys	()	;
}	;

class 	LIBKBASE_API	KBCopyTable : public KBCopyBase
{
public	:
	enum
	{	OptAppend	= 0,
		OptReplace	= 1,
		OptUpdate	= 2,
		OptUpdIns	= 3,
		OptInsNew	= 4,
		OptCompare	= 5
	}	;

private	:

	bool		m_srce	   ;
	KBLocation	m_location ;

	QString		m_server   ;
	QString		m_table	   ;
	QStringList	m_fields   ;

	QString		m_where	   ;	/* Source where condition	*/
	QString		m_order	   ;	/* Source ordering		*/
	QString		m_useWhere ;	/* Paramater subsituted ...	*/
	QString		m_useOrder ;

	uint		m_option   ;	/* Destination option		*/
	QString		m_optField ;	/* Destination optio field	*/

	KBDBLink	m_dbLink   ;	/* Link to database server	*/
	KBSQLSelect	*m_select  ;	/* Source select		*/
	KBSQLInsert	*m_insert  ;	/* Destination insert		*/
	KBSQLUpdate	*m_update  ;	/* Destination update		*/
	KBSQLSelect	*m_count   ;	/* Count extant records		*/
	KBSQLSelect	*m_compare ;	/* Select for comparisom	*/
	bool		m_qExec	   ;	/* Query executed flag		*/

	KBValue		*m_copies  ;	/* Destination local buffer	*/
	QList<KBType>	m_types	   ;	/* Insert/update types		*/

					/* SOURCE			*/
	uint		m_sRow	   ;	/* Select row count		*/

					/* DESTINATION			*/
	bool		m_getPKey  ;	/* Insert needs primary key	*/
	QString		m_pkName   ;	/* Primary key column name	*/
	uint		m_uIndex   ;	/* Update column index		*/

	uint		m_rDeleted ;	/* Number of rows deleted	*/
	uint		m_rUpdated ;	/* Number of rows updated	*/
	uint		m_rInserted;	/* Number of rows inserted	*/

					/* Compare results		*/
	KBCopyCompare	m_rMissing ;	/* Missing keys			*/
	KBCopyCompare	m_rMultiple;	/* Multiple keys		*/
	KBCopyCompare	m_rSame	   ;	/* Records are the same		*/
	KBCopyCompare	m_rDiffer  ;	/* Records differ		*/

public	:

	KBCopyTable		(bool, KBLocation &)	;
	virtual	~KBCopyTable	()		;

	virtual	cchar		*tag		() ;

	virtual	bool		valid		(KBError     &) ;
	virtual	bool		set		(QDomElement &, KBError &) ;
	virtual	void		def		(QDomElement &) ;

	virtual	void		getColumnNames	(QStringList &) ;
	virtual	bool		prepare		(const QDict<QString>   &, KBCopyBase *) ;
	virtual	int		getNumCols	() ;
	virtual	int		getRow		(KBValue *, uint, bool  &) ;
	virtual	bool		putRow		(KBValue *, uint  ) ;
	virtual	bool		finish		(QString &) ;

	void			reset		() ;
	void			setServer	(const QString &) ;
	void			setTable	(const QString &) ;
	void			addField	(const QString &) ;
	void			setWhere	(const QString &) ;
	void			setOrder	(const QString &) ;
	void			setOption	(uint, const QString &) ;

	inline const QString	&getServer	() { return m_server   ; }
	inline const QString	&getTable	() { return m_table    ; }
	inline QStringList	&getFields	() { return m_fields   ; }
	inline const QString	&getWhere	() { return m_where    ; }
	inline const QString	&getOrder	() { return m_order    ; }
	inline uint		 getOption	() { return m_option   ; }
	inline const QString	&getOptField	() { return m_optField ; }
}	;

#endif	// __KB_COPYTABLE_H
