/***************************************************************************
    file	         : kb_dialog.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#include	<qobjectlist.h>
#include	<qpushbutton.h>

#include	"tk_config.h"
#include	"tk_icons.h"

#ifndef 	_WIN32
#include 	"kb_dialog.moc"
#else
#include 	"kb_dialog.h"
#endif

#include	"kb_classes.h"
#include	"kb_options.h"



static	char	configGroup[]	= "Dialog Sizes" ;

/*  _KBDialog								*/
/*  _KBDialog	: Constructor for kbase dialog base class		*/
/*  caption	: QString	  : Dialog box caption			*/
/*  modal	: bool		  : Modal flag				*/
/*  name	: cchar *	  : Dialog name				*/
/*  size	: const QString & : Default size			*/
/*  (returns)	: _KBDialog	  :					*/

_KBDialog::_KBDialog
	(	QString		caption,
		bool		modal,
		const char	*name,
		const QSize	&size
	)
	:
	QDialog	(qApp->activeWindow(), name, modal),
	m_name	(name)
{
	init	(caption, name, size) ;
}

/*  _KBDialog								*/
/*  _KBDialog	: Constructor for kbase dialog base class		*/
/*  caption	: QString	  : Dialog box caption			*/
/*  modal	: bool		  : Modal flag				*/
/*  name	: cchar *	  : Dialog name				*/
/*  size	: const QString & : Default size			*/
/*  (returns)	: _KBDialog	  :					*/

_KBDialog::_KBDialog
	(	QString		caption,
		const char	*name,
		const QSize	&size
	)
	:
	QDialog	(qApp->activeWindow(), name, true),
	m_name	(name)
{
	init	(caption, name, size) ;
}

/*  _KBDialog								*/
/*  _KBDialog	: Destructor for kbase dialog base class		*/
/*  (returns)	:		:					*/

_KBDialog::~_KBDialog ()
{
	if (!m_name.isEmpty())
	{
		TKConfig *config = TKConfig::getConfig() ;

		config->setGroup   (configGroup) ;
		config->writeEntry (m_name, m_lastSize) ;
	}
}

/*  _KBDialog								*/
/*  init	: Common initialisation code				*/
/*  caption	: QString	  : Dialog box caption			*/
/*  name	: cchar *	  : Dialog name				*/
/*  size	: const QString & : Default size			*/
/*  (returns)	: void		  :					*/

void	_KBDialog::init
	(	const QString	&caption,
		const char	*name,
		const QSize	&size
	)
{
	setIcon	(getSmallIcon ("rekall")) ;

	/* Main reason for this is to get the standard application	*/
	/* palette .... not that this is needed much any more.		*/
	setCaption (caption) ;
	setPalette (QApplication::palette()) ;
	setFont    (QApplication::font   ()) ;

	m_showMaxed  = false ;

	if (name != 0)
	{
		TKConfig *config = TKConfig::getConfig() ;
		config->setGroup (configGroup) ;

		m_lastSize	 = config->readSizeEntry (name, &size) ;
	}
}

/*  _KBDialog								*/
/*  getSpacing	: Get layout spacing					*/
/*  layout	: QLayout *	: Requesting layout			*/
/*  (returns)	: int		: Spacing				*/

int	_KBDialog::getSpacing
	(	QLayout	*
	)
{
	return	KBOptions::getDlgSpacing() ;
}

/*  _KBDialog								*/
/*  getMargin	: Get layout margin					*/
/*  layout	: QLayout *	: Requesting layout			*/
/*  (returns)	: int		: Spacing				*/

int	_KBDialog::getMargin
	(	QLayout	*
	)
{
	return	KBOptions::getDlgMargin () ;
}

/*  _KBDialog								*/
/*  show	: Trap show to set layout				*/
/*  (returns)	: void		:					*/

void	_KBDialog::show ()
{
	static	bool	inShow	= false	;

	setupLayout	(this)	;

	QObjectList   *blist = queryList ("QPushButton", 0, false, false) ;
	if (blist != 0)
	{
		QObjectListIt	iter (*blist) ;
		QObject		*obj ;
		while ((obj = iter.current()) != 0)
		{
			QPushButton *b = (QPushButton *)obj ;

			if (qstrcmp(obj->name(), "ok"    ) == 0)
			{
				if (b->text().isEmpty()) b->setText(TR("OK"    )) ;
				connect (obj, SIGNAL(clicked()), SLOT(accept())) ;
			}
			if (qstrcmp(obj->name(), "cancel") == 0)
			{
				if (b->text().isEmpty()) b->setText(TR("Cancel")) ;
				connect (obj, SIGNAL(clicked()), SLOT(reject())) ;
			}

			iter += 1 ;
		}
	}

	if	(m_showMaxed && !inShow)
	{
		inShow	= true	;
		QWidget::showMaximized() ;
		inShow	= false	;
	}
	else if	(m_lastSize.isValid())
	{
		resize		(m_lastSize) ;
		QDialog::show	() ;
	}
	else	QDialog::show	() ;
}

/*  _KBDialog								*/
/*  resizeEvent	: Trap resize events					*/
/*  e		: QResizeEvent * : The event				*/
/*  (returns)	: void		 :					*/

void	_KBDialog::resizeEvent
	(	QResizeEvent	*e
	)
{
	m_lastSize = e->size()  ;
	QDialog::resizeEvent(e) ;
}

/*  _KBDialog								*/
/*  setupLayout	: Setup layout						*/
/*  widget	: QWidget *	: Parent widget for layout		*/
/*  (returns)	: void		:					*/

void	_KBDialog::setupLayout
	(	QWidget		*widget
	)
{
	setupLayout
	(	widget,
		getMargin (widget->layout()),
		getSpacing(widget->layout())
	)	;
}


/*  _KBDialog								*/
/*  setupLayout	: Setup layout						*/
/*  layout	: QLayout *	: Layout to set				*/
/*  (returns)	: void		:					*/

void	_KBDialog::setupLayout
	(	QLayout		*layout
	)
{
	if (layout != 0)
		setupLayout (layout, getMargin (layout), getSpacing(layout)) ;
}


/*  [ STATIC METHODS ] -----------------------------------------------  */

/*  _KBDialog								*/
/*  setupLayout	: Setup layout						*/
/*  widget	: QWidget *	: Parent widget for layout		*/
/*  margin	: int		: Margin				*/
/*  spacing	: int		: Spacing				*/
/*  (returns)	: void		:					*/

void	_KBDialog::setupLayout
	(	QWidget		*widget,
		int		margin,
		int		spacing
	)
{
	if (widget->layout() != 0)
		setupLayout (widget->layout(), margin, spacing) ;
}

/*  _KBDialog								*/
/*  setupLayout	: Setup layout						*/
/*  layout	: QLayout *	: Layout to set				*/
/*  margin	: int		: Margin				*/
/*  spacing	: int		: Spacing				*/
/*  (returns)	: void		:					*/

void	_KBDialog::setupLayout
	(	QLayout		*layout,
		int		margin,
		int		spacing
	)
{
	if (layout != 0)
	{
		if (margin  < 0) margin  = KBOptions::getDlgMargin () ;
		if (spacing < 0) spacing = KBOptions::getDlgSpacing() ;

		layout->setMargin  (margin ) ;
		layout->setSpacing (spacing) ;

		QLayoutIterator iter = layout->iterator() ;
		QLayoutItem	*lay ;

		while ((lay = iter.current()) != 0)
		{	setupLayout (lay->layout(), margin, spacing) ;
			++iter ;
		}
	}
}


