/***************************************************************************
    file	         : kb_docroot.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_DOCROOT_H
#define	_KB_DOCROOT_H

#include "libkbase_exports.h"

#include 	<qlist.h>
#include 	<qstringlist.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_attrdict.h"
#include	"kb_qrybase.h"


/*  KBDocStatus								*/
/*  -----------								*/
/*  This simple structure is used as an argument by the "statusChange"	*/
/*  signal so that we can add fields with minimal API changes.		*/

struct	KBDocStatus
{
	KBQryBase::Locking	m_locking	;
}	;

/*  ------------------------------------------------------------------  */

/*  KBDocRoot								*/
/*  ---------								*/
/*  This class is used at the top-most node in parsed documents, such	*/
/*  as forms and reports. It holds information, such as the document	*/
/*  location, that is common to all such documents.			*/

class	LIBKBASE_API	KBDocRoot : public QObject
{
	Q_OBJECT

	KBNode		*m_parent	;	/* Embedding node ...	*/
	QList<KBNode>	&m_children	;	/* ... and its children	*/
	bool		m_donePDlg	;	/* Parameter dialog run	*/
	bool		m_gotExecError	;	/* Execution error flag	*/

	QStringList	m_scripts	;	/* List of scripts	*/
	QStringList	m_imports	;	/* List of imports	*/

	KBDocStatus	m_docStatus	;

signals	:

	void		execError 	()		;
	void		requestClose	(int)		;
	void		statusChange	(KBDocStatus *)	;

protected :

	KBLocation	m_location	;	/* Database location	*/
	KBScriptIF	*m_scrIface	;	/* Scripting interface	*/
	KBAttrDict	*m_paramDict	;	/* Parameter dictionary	*/

public	:

	KBDocRoot	(KBNode *, QList<KBNode> &, const KBLocation &) ;
       ~KBDocRoot	() ;

	inline		KBDBInfo	 	*getDBInfo   () { return m_location.dbInfo ; }
	inline		const KBLocation 	&getLocation () { return m_location 	   ; }

	void		reset			() ;

	KBScriptIF	*getScriptIF		(QString, bool &, KBError &) ;
	KBScriptIF	*loadScripting		(bool &, KBError &) ;

	KB::ShowRC	setParamDict		(const QDict<QString> &, KBError &) ;
	QString		getParamValue		(cchar *) ;
	void		setParamValue		(cchar *, const QString &) ;

	inline	const QStringList &getScripts	() { return m_scripts ; }
	inline	const QStringList &getImports	() { return m_imports ; }

	void		doExecError		() ;
	void		doRequestClose		(int) ;
	void		doSetLocking		(KBQryBase::Locking) ;
}	;


#endif	// _KB_DOCROOT_H
