/***************************************************************************
    file	         : kb_event.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_EVENT_H
#define	_KB_EVENT_H

#include	<qvaluelist.h>

#include	"libkbase_exports.h"
#include	"kb_emitter.h"
#include	"kb_script.h"
#include	"kb_macro.h"



/*  Create a typedef for C++-level event functions. The arguments are:	*/
/*	* Pointer to invoking event					*/
/*	* Reference to value return value				*/
/*	* Number of arguments						*/
/*	* Vector of arguments						*/
/*	* Error return							*/

typedef	KBScript::ExeRC	(*CPPFunc)
		(	KBEvent		*,
			KBValue 	&,
			uint		,
			KBValue		*,
			KBError		&
		)	;

class	KBAttrDlg	;
class	KBAttrItem	;

/*  KBEvent								*/
/*  -------								*/
/*  This class encapsulates the script associated with an event, such	*/
/*  as a button click or a new record becoming current.			*/

class	LIBKBASE_API	KBEvent : public KBAttrStr
{

	KBNode	 	*m_parent   ;	/* Owning node			*/
	QString	 	m_base	    ;	/* Base for shortcut action	*/
	bool	 	m_disable   ;	/* Inline code disabled		*/
	KBScriptCode	*m_code	    ;	/* Inline code for execution	*/
	KBEmitter	*m_emitter  ;	/* Signal emitter		*/

	CPPFunc		m_cppFunc   ;	/* C++-level event function	*/
	KBMacroExec	*m_macro    ;	/* Macro code if set		*/

	KBEvent		*m_override ;
	KBEvent		*m_inherit  ;

	QValueList<int>	m_breakpoints	;

	void		init		() ;
	void		clearOverride	() ;

public	:

	KBEvent	(KBNode *, cchar *, cchar *, const QDict<QString> &, uint = 0) ;
	KBEvent	(KBNode *, cchar *, cchar *, cchar  *, uint = 0) ;
	KBEvent	(KBNode *, cchar *, cchar *, KBNode *, uint = 0) ;
       ~KBEvent	() ;

	void			setOverride	(const QString &) ;
	virtual	bool		showAs		(KB::ShowAs)	  ;

	virtual	void		setValue	(KBAttrItem    *) ;
	virtual	void		setValue	(const QString &) ;

	virtual	void		setCode		(const QString &, bool) ;
	virtual	void		tidy		()		  ;

	virtual	void		setMacro	(KBMacroExec   *) ;
	virtual	KBMacroExec	*getMacro	() ;


	virtual	void		setCPPFunc	(CPPFunc	) ;

	virtual	void		printAttr 	(QString &, QString &, int) ;
	virtual	KBEvent		*isEvent	() ;

	KBEmitter		*getEmitter	() ;
	void			clearEmitter	() ;

	KB::ScriptRC		doExecute	(KBValue &, uint, KBValue *, KBError &) ;
	KB::ScriptRC		execute		(KBValue &, uint = 0, KBValue * = 0) ;

	virtual QString		getDescription	() ;

	void			setBreakpoints	(QValueList<int> &) ;
	const QValueList<int>	&breakpoints	() ;

#if	! __KB_RUNTIME
	virtual	KBAttrItem	*getAttrItem	() ;
	virtual	KBAttrDlg	*getAttrDlg
				(	QWidget			*,
					KBAttrItem		*,
					QDict<KBAttrItem>	&
				)	;

	static	QString		trimEvent	(QString)	;
#endif
}	;

#endif	// _KB_EVENT_H
