/***************************************************************************
    file	         : kb_font.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qapp.h>
#include	<qfont.h>
#include	<qstring.h>

#include	"kb_classes.h"
#include	"kb_font.h"


/*  KBFont								*/
/*  specToFont	: Convert font specification to font			*/
/*  spec	: const QString & : Specification string		*/
/*  (returns)	: QFont		  : The font				*/

QFont	KBFont::specToFont
	(	const	QString	&spec
	)
{
	QString	     family  = "Times"	;
	QString	     points  = "12"	;
	QString	     weight  = "50"	;
	QString	     italic  = "0"	;
	int	     index   = 0 ;
	int	     offset  ;

	if (spec.isEmpty()) return QApplication::font() ;

	if ((offset = spec.find (':', index)) >= 0)
	{	family	= spec.mid (index, offset - index) ;
		index	= offset + 1 ;
	}
	if ((offset = spec.find (':', index)) >= 0)
	{	points	= spec.mid (index, offset - index) ;
		index	= offset + 1 ;
	}
	if ((offset = spec.find (':', index)) >= 0)
	{	weight	= spec.mid (index, offset - index) ;
		index	= offset + 1 ;
	}
	if (index >= 0) italic = spec.mid (index) ;

//	fprintf	(stderr, "[%s][%s][%s][%s]\n",
//			 (cchar *)family,
//			 (cchar *)points,
//			 (cchar *)weight,
//			 (cchar *)italic) ;

	return	QFont	(family, points.toInt(), weight.toInt(), italic.toInt()) ;
}

/*  KBFont								*/
/*  fontToSpec	: Convert font to font specification			*/
/*  font	: const QFont & : The font				*/
/*  (returns)	: QString	: Specification string			*/

QString	KBFont::fontToSpec
	(	const QFont	&font
	)
{
	return	QString ("%1:%2:%3:%4")
		       .arg (     font.family   ())
		       .arg (     font.pointSize())
		       .arg (     font.weight   ())
		       .arg ((int)font.italic   ()) ;
}
