/***************************************************************************
    file	         : kb_graphic.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB__GRAPHIC_H
#define	_KB__GRAPHIC_H

#include	"libkbase_exports.h"

#include	"kb_object.h"
#include	"kb_qtgraphic.h"
#include	"kb_attrserver.h"
#include	"kb_attrimage.h"


/*  KBGraphic								*/
/*  -----------								*/
/*  This class is used for XML parse tree elements corresponding to	*/
/*  statis graphic elements.						*/

class	LIBKBASE_API	KBGraphic : public KBObject
{
	Q_OBJECT

	KBAttrImage	m_image		;
	KBAttrUInt	m_autosize	;
	KBCtrlGraphic	*m_graphic	;

	KBReport	*m_report	;	/* Embedding report	*/

	bool		loadImage ()	;

protected :

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	() ;
#endif

public	:

	KBGraphic (KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBGraphic (KBNode  *, KBGraphic *) ;
virtual~KBGraphic () ;

	virtual	void		buildCtrls	(uint, int, int ) ;
	virtual	KBNode		*replicate	(KBNode *) ;
	virtual	void		showAs		(KB::ShowAs) ;

	inline	uint	autoSize ()
	{
		return	m_autosize.getIntValue() ;
	}
}	;

#if	! __KB_RUNTIME
extern	bool LIBKBASE_API graphicPropDlg
			  (	KBGraphic	*,
				cchar		*,
				QList<KBAttr>	&
			  )	;
#endif
#endif	// _KB__GRAPHIC_H
