/***************************************************************************
    file	         : kb_listboxpair.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"


#ifndef 	_WIN32
#include	"kb_listboxpair.moc"
#else
#include	"kb_listboxpair.h"
#endif


/*  KBListBoxPair							*/
/*  KBListBoxPair: Constructor for paired list box handler		*/
/*  source	 : QListBox *	 : Source list box			*/
/*  dest	 : QListBox *	 : Destination list box			*/
/*  bAdd	 : QPushButton * : Add (source->destination) button	*/
/*  bAddAll	 : QPushButton * : Add all button			*/
/*  bRemove	 : QPushButton * : Remove (desination->source) button	*/
/*  bUp		 : QPushButton * : Move destination element up		*/
/*  bDown	 : QPushButton * : Move destination element down	*/
/*  multi	 : bool		 : Source entries may be multiply added	*/
/*  (returns)	 : KBListBoxPair :					*/

KBListBoxPair::KBListBoxPair
	(	QListBox	*source,
		QListBox	*dest,
		QPushButton	*bAdd,
		QPushButton	*bAddAll,
		QPushButton	*bRemove,
		QPushButton	*bUp,
		QPushButton	*bDown,
		bool		multi
	)
	:
	m_source	(source),
	m_dest		(dest),
	m_bAdd		(bAdd),
	m_bAddAll	(bAddAll),
	m_bRemove	(bRemove),
	m_bUp		(bUp),
	m_bDown		(bDown),
	m_multi		(multi)
{
	m_bAdd	 ->setText (TR("Add >>"    )) ;
	m_bAddAll->setText (TR("Add All >>")) ;
	m_bRemove->setText (TR("<< Remove" )) ;
	m_bUp	 ->setText (TR("Up"        )) ;
	m_bDown	 ->setText (TR("Down"      )) ;

	connect	(m_bAdd,	SIGNAL(clicked()),	  SLOT(clickAdd      ())) ;
	connect	(m_bAddAll,	SIGNAL(clicked()),	  SLOT(clickAddAll   ())) ;
	connect	(m_bRemove,	SIGNAL(clicked()),	  SLOT(clickRemove   ())) ;
	connect	(m_bUp,		SIGNAL(clicked()),	  SLOT(clickUp       ())) ;
	connect	(m_bDown,	SIGNAL(clicked()),	  SLOT(clickDown     ())) ;
	connect	(m_dest,	SIGNAL(highlighted(int)), SLOT(setButtonState())) ;
	connect	(m_source,	SIGNAL(highlighted(int)), SLOT(setButtonState())) ;

	connect
	(	m_source,
		SIGNAL(doubleClicked(QListBoxItem *)),
		SLOT  (clickAdd     ())
	)	;
	connect
	(	m_dest,
		SIGNAL(doubleClicked(QListBoxItem *)),
		SLOT  (clickRemove  ())
	)	;

	setButtonState   () ;
}

/*  KBListBoxPair							*/
/*  setButtonState							*/
/*		: Set state of buttons					*/
/*  (returns)	: void		  :					*/

void	KBListBoxPair::setButtonState ()
{
	int	sCur	= m_source->currentItem() ;
	int	dCur	= m_dest  ->currentItem() ;

	m_bAdd   ->setEnabled (sCur >= 0) ;
	m_bRemove->setEnabled (dCur >= 0) ;
	m_bAddAll->setEnabled (m_source->count() > 0) ;

	m_bUp    ->setEnabled (dCur >  0) ;
	m_bDown  ->setEnabled (dCur >= 0 && dCur < (int)m_dest->count() - 1) ;
}

/*  KBListBoxPair							*/
/*  clickAdd	: Handle field addition					*/
/*  (returns)	: void		:					*/

void	KBListBoxPair::clickAdd ()
{
	int	sCur	= m_source->currentItem () ;
	int	dCur	= m_dest  ->currentItem () ;

	if (sCur >= 0)
	{
		m_dest->insertItem     (replicate (m_source->item(sCur)), dCur + 1) ;
		m_dest->setCurrentItem (dCur + 1) ;

		/* If multiple addition is allowed then move down the	*/
		/* souce list, otherwise remove the source item.	*/
		if (!m_multi)
		{	m_source->removeItem     (sCur) ;
			m_source->setCurrentItem (sCur) ;
		}
		else	m_source->setCurrentItem (sCur + 1) ;

		setButtonState     () ;
		emit destChanged   (true) ;
	}
}

/*  KBListBoxPair							*/
/*  clickAddAll	: Handle all-fields addition				*/
/*  (returns)	: void		:					*/

void	KBListBoxPair::clickAddAll ()
{
	int	dCur	= m_dest->currentItem () + 1 ;

	for (uint idx = 0 ; idx < m_source->count() ; idx += 1)
	{
		m_dest->insertItem (replicate (m_source->item(idx)), dCur) ;
		dCur += 1 ;
	}

	if (!m_multi)
		m_source->clear () ;

	setButtonState   () ;
	emit destChanged (true) ;
}

/*  KBListBoxPair							*/
/*  clickRemove	: Handle field addition					*/
/*  (returns)	: void		:					*/

void	KBListBoxPair::clickRemove ()
{
	int	sCur	= m_source->currentItem () ;
	int	dCur	= m_dest  ->currentItem () ;

	if (dCur >= 0)
	{
		/* If multiple addition is not allowed then transfer	*/
		/* the destination entry back to the source list.	*/
		if (!m_multi)
		{	m_source->insertItem     (replicate (m_dest->item(dCur)), sCur + 1) ;
			m_source->setCurrentItem (sCur + 1) ;
		}

		m_dest->removeItem     (dCur) ;
		m_dest->setCurrentItem (dCur) ;

		setButtonState   () ;
		emit destChanged (true) ;

	}
}

/*  KBListBoxPair							*/
/*  clickUp	: Move field up list					*/
/*  (returns)	: void		:					*/

void	KBListBoxPair::clickUp ()
{
	int	dCur	= m_dest->currentItem () ;

	if (dCur > 0)
	{
		QListBoxItem *item = m_dest->item (dCur) ;

		m_dest->takeItem	(item)		 ;
		m_dest->insertItem	(item, dCur - 1) ;
		m_dest->setCurrentItem	(dCur - 1)	 ;
		setButtonState   	() ;
		emit destChanged	(false) ;
	}
}

/*  KBListBoxPair							*/
/*  clickDown	: Move field down list					*/
/*  (returns)	: void		:					*/

void	KBListBoxPair::clickDown ()
{
	int	dCur	= m_dest->currentItem () ;

	if (dCur < (int)m_dest->count() - 1)
	{
		QListBoxItem *item = m_dest->item (dCur) ;

		m_dest->takeItem	(item)		 ;
		m_dest->insertItem	(item, dCur + 1) ;
		m_dest->setCurrentItem	(dCur + 1)	 ;
		setButtonState		() ;
		emit destChanged	(false) ;
	}
}

/*  ------------------------------------------------------------------  */

/*  KBListBoxPairText							*/
/*  KBListBoxPairText							*/
/*		: Constructor for paired text list box handler		*/
/*  source	: QListBox *	: Source list box			*/
/*  dest	: QListBox *	: Destination list box			*/
/*  bAdd	: QPushButton * : Add (source->destination) button	*/
/*  bAddAll	: QPushButton * : Add all button			*/
/*  bRemove	: QPushButton * : Remove (desination->source) button	*/
/*  bUp		: QPushButton * : Move destination element up		*/
/*  bDown	: QPushButton * : Move destination element down		*/
/*  multi	: bool		: Source entries may be multiply added	*/
/*  (returns)	: KBListBoxPair :					*/

KBListBoxPairText::KBListBoxPairText
	(	QListBox	*source,
		QListBox	*dest,
		QPushButton	*bAdd,
		QPushButton	*bAddAll,
		QPushButton	*bRemove,
		QPushButton	*bUp,
		QPushButton	*bDown,
		bool		multi
	)
	:
	KBListBoxPair (source, dest, bAdd, bAddAll, bRemove, bUp, bDown, multi)
{
}

QListBoxItem
	*KBListBoxPairText::replicate
	(	QListBoxItem	*item
	)
{
	return	new QListBoxText (0, item->text()) ;
}

