/***************************************************************************
    file	         : kb_listview.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_LISTVIEW_H
#define	__KB_LISTVIEW_H

#include	"libkbase_exports.h"

#include	<qlistview.h>
#include	<qlist.h>

/*  KBListView								*/
/*  ----------								*/
/*  This class is a simple extension of QListView, which records the	*/
/*  state of the Control and Shift keys when events occur.		*/

class LIBKBASE_API	KBListView : public QListView
{

	int		state		;
	QEvent::Type	type		;
	bool		selecting	;

protected :

	virtual	void	contentsMouseReleaseEvent     (QMouseEvent *) ;
	virtual	void	contentsMouseDoubleClickEvent (QMouseEvent *) ;
	virtual	void	keyPressEvent		      (QKeyEvent   *) ;

public	:

	inline	KBListView
		(	QWidget	*parent
		)
		:
		QListView (parent)
	{
		clear	() ;
	}

	inline	void	clear ()
	{
		state	  = 0			;
		type	  = QEvent::None	;
		selecting = false		;
	}

	inline	int		getState	() { return state	; }
	inline	QEvent::Type	getType		() { return type   	; }
	inline	bool		isSelecting	() { return selecting	; }

	bool			anySelected	()	;
	int			someSelected	(int)	;
	int			countSelected	()	;
	QList<QListViewItem>	getSelection	()	;

	virtual	void		setOpen		(QListViewItem *, bool) ;
	virtual	void		setSelected	(QListViewItem *, bool) ;
}	;

#endif	// __KB_LISTVIEW_H
