/***************************************************************************
    file	         : kb_multilistbox.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_MULTILISTBOX
#define	__KB_MULTILISTBOX

#include	<qstring.h>
#include	<qstringlist.h>
#include	<qvaluelist.h>
#include	<qlistbox.h>
#include	<qfontmetrics.h>
#include	<qpainter.h>

#include	"libkbase_exports.h"

class	KBMultiListBoxItem	;
class	KBMultiListBox		;


/*  KBMultiListBoxItem							*/
/*  ------------------							*/
/*  Entry for multi-column list box below				*/

class	LIBKBASE_API KBMultiListBoxItem : public QListBoxItem
{
	KBMultiListBox		*m_parent	;
	QStringList		m_values 	;
	uint			m_height	;

protected :


	virtual	void	paint	(QPainter *)	;

public	:

	KBMultiListBoxItem	(KBMultiListBox *, QListBoxItem *, const QStringList &) ;
	KBMultiListBoxItem	(KBMultiListBox *, QListBoxItem *, const QString &) ;

	uint		width	(const QFontMetrics &, uint) ;

	virtual	int	height	(const QListBox *) const     ;
	virtual	QString	text	() const ;
}	;


/*  KBMultiListBox							*/
/*  --------------							*/
/*  This is a multicolumn listbox, in the sense that each entry		*/
/*  comprises one or more items (a sort of flat list view). Currently,	*/
/*  it only handles text.						*/

class	LIBKBASE_API KBMultiListBox : public QListBox
{
	bool			m_colSep	;
	uint			m_showCols	;
	QValueList<uint>	m_widths	;
	uint			m_nCols		;
	KBMultiListBoxItem	*m_last		;
	bool			m_doCalc	;

public	:

	KBMultiListBox	(QWidget *, bool = false, uint = 999) ;

	void		insertEntry	(const QStringList &) ;
	void		insertEntry	(const QString	   &) ;
	void		calcGeometry	()	;
	void		clear		()	;

	inline	bool	colSep	 ()
	{
		return	m_colSep	;
	}
	inline	uint	showCols ()
	{
		return	m_showCols	;
	}

	inline	void	setShowCols
		(	uint	showCols
		)
	{
		m_showCols = showCols	;
	}

	inline	const QValueList<uint>	&widths	()
	{
		return	m_widths ;
	}
}	;


#endif	// __KB_MULTILISTBOX
