/***************************************************************************
    file	         : kb_qtbutton.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_qtbutton.h"

#include	"kb_button.h"
#include	"kb_display.h"
#include	"kb_writer.h"



/*  KBCtrlButton								*/
/*  KBCtrlButton: Constructor for pushbutton wrapper			*/
/*  display	: KBDisplay *	: Parent display			*/
/*  button	: KBButton *	: Parent button				*/
/*  design	: bool		: Design mode				*/
/*  (returns)	: KBCtrlButton	:					*/

KBCtrlButton::KBCtrlButton
	(	KBDisplay	*display,
		KBButton	*button
	)
	:
	QPushButton (display->getDisplayWidget()),
	KBControl    (this, display, button),
	button	    (button)
{
	QPushButton::connect
	(	(QPushButton *)this,	SIGNAL(clicked()),
		button, 		SLOT  (clicked())
	) ;
}

/*  KBCtrlButton							*/
/*  ~KBCtrlButton: Destructor for button widget				*/
/*  (returns)	 :		:					*/

KBCtrlButton::~KBCtrlButton ()
{
}

/*  KBCtrlButton							*/
/*  setValue	: Set button text					*/
/*  value	: const KBValue &: Value for text			*/
/*  (returns)	: void		 :					*/

void	KBCtrlButton::setValue
	(	const KBValue	&value
	)
{
	setText (value.getRawText()) ;
}

/*  KBCtrlButton								*/
/*  giveFocus	: Give focus to the control				*/
/*  (returns)	: void							*/

void	KBCtrlButton::giveFocus ()
{
	QButton::setFocus () ;
}

/*  KBCtrlButton								*/
/*  write	: Write field 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: Field area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  extra	: int &		: Return extra space			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlButton::write
	(	KBWriter	*writer,
		QRect		rect,
		const KBValue	&value,
		bool		fSubs,
		int		&extra
	)
{
	if (writer->asReport())
	{
		extra	= 0	;
		return	true	;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
}
