/***************************************************************************
    file	         : kb_qtfield.cpp
    copyright            : (C) 1999,2000,2001,2002,2003,2004 by Mike Richardson
			   (C) 2000,2001,2002,2003,2004 by theKompany.com
			   (C) 2001,2002,2003,2004 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qcursor.h>
#include	<qvalidator.h>

#ifndef 	_WIN32
#include 	"kb_qtfield.moc"
#else
#include 	"kb_qtfield.h"
#endif

#include	"kb_field.h"
#include	"kb_writer.h"
#include	"kb_block.h"
#include	"kb_display.h"
#include	"kb_docroot.h"
#include	"kb_helper.h"


/*  KBCtrlField								*/
/*  KBCtrlField	: Constructor for line edit wrapper			*/
/*  display	: KBDisplay *	: Parent display			*/
/*  field	: KBField *	: Parent field				*/
/*  drow	: uint		: Row number in field			*/
/*  (returns)	: KBCtrlField	:					*/

KBCtrlField::KBCtrlField
	(	KBDisplay	*display,
		KBField		*field,
		uint		drow
	)
	:
	TKLineEdit	(display->getDisplayWidget()),
	KBControl	(this, display, field, drow),
	m_field		(field),
	m_inputMask	(this)
{
	m_bHelp		= 0	;
	m_inSetValue	= false	;

	connect
	(	&m_inputMask,
		SIGNAL(textChangedTo(const QString &)),
		SLOT  (textChangedTo(const QString &))
	)	;
}

/*  KBCtrlField								*/
/*  ~KBCtrlField: Desctructor for field class				*/
/*  (returns)	:		:					*/

KBCtrlField::~KBCtrlField ()
{
	DELOBJ	(m_bHelp) ;
}

/*  KBCtrlField								*/
/*  showName	: Show control name					*/
/*  (returns)	: void		:					*/

void	KBCtrlField::showName ()
{
#if	! __KB_RUNTIME
	if ((m_drow == 0) && (m_showing == KB::ShowAsDesign))
		setText (m_field->getName()) ;
#endif
}


/*  KBCtrlField								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCtrlField::showAs
	(	KB::ShowAs	mode
	)
{
	KBControl::showAs (mode) ;

	DELOBJ	(m_bHelp) ;
	redraw	()	  ;

	setCursor
	(	m_showing == KB::ShowAsDesign ?
				QCursor(Qt::arrowCursor) :
				QCursor(Qt::ibeamCursor)
	)	;

	FIELD_NOCHANGE
	(
		setText  ("") ;
	)
}

/*  KBCtrlField								*/
/*  setValue	: Set field value					*/
/*  value	: const KBValue &: Value				*/
/*  (returns)	: void		 :					*/

void	KBCtrlField::setValue
	(	const KBValue	&value
	)
{
//	fprintf
//	(	stderr,
//		"KBCtrlField::setValue: [%s]->[%s]\n",
//		(cchar *)value.getRawText(),
//		(cchar *)value.getText(m_field->getFormat())
//	)	;

	FIELD_NOCHANGE
	(
		setText (value.getText(m_field->getFormat())) ;
	)

	KBControl::setValue (value) ;
}

/*  KBCtrlField								*/
/*  getValue	: Get field value					*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBCtrlField::getValue ()
{
	/* If the control is empty and the initial value was null (as	*/
	/* opposed to an empty string), then return a null string.	*/
	if (text().isEmpty() && getIniValue().isNull())
		return	KBValue (m_field->getFieldType()) ;

	if (m_field->getDeFormat ())
		return	KBValue (text(), m_field->getFieldType(), m_field->getFormat()) ;

	return	KBValue (text(), m_field->getFieldType()) ;
}

/*  KBCtrlField								*/
/*  clearValue	: Clear value for specified query and display row	*/
/*  query	: bool		: Clearing for query			*/
/*  (returns)	: void		:					*/

void	KBCtrlField::clearValue
	(	bool	query
	)
{
	FIELD_NOCHANGE
	(
		setText ("") 	   ;
	)

	KBControl::clearValue (query) ;
}

/*  KBCtrlField								*/
/*  changed	: Test if field value has been changed			*/
/*  (returns)	: bool		: TRUE if changed			*/

bool	KBCtrlField::changed ()
{
	/* Special case: This handles the situation where the inital	*/
	/* value is null, otherwise we get empty != null.		*/
	if (text().isEmpty() && getIniValue().getRawText().isEmpty())
		return false ;

	return	text() != getIniValue().getText(m_field->getFormat()) ;
}

/*  KBCtrlField								*/
/*  isEmpty	: See if control is empty				*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlField::isEmpty ()
{
	return	text().isEmpty() ;
}

/*  KBCtrlField								*/
/*  isValid	: See if control is valid				*/
/*  allowNull	: bool		: True to ignore not-null check		*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlField::isValid
	(	bool		allowNull
	)
{
	QString	value	;

	/* If the control is empty and the initial value was null (as	*/
	/* opposed to an empty string), then use a null value.		*/
	if (!text().isEmpty() || !getIniValue().isNull())
		if (m_field->getDeFormat ())
			value	= KBValue::deFormat
				  (	text(),
					m_field->getFieldType(),
					m_field->getFormat()
				  ) ;
		else	value	= text () ;
		
	if (!m_field->checkValid (value, allowNull))
	{	setError (m_field->lastError()) ;
		return	 false ;
	}

	return	true ;
}

/*  KBCtrlField								*/
/*  focusInEvent: Handle focus arrival					*/
/*  e		: QFocusEvent *	: Focus arrival event			*/
/*  (returns)	: void		:					*/

void	KBCtrlField::focusInEvent
	(	QFocusEvent	*e
	)
{
	TKLineEdit::focusInEvent (e) ;

	if (e->reason() == QFocusEvent::Other)
	{
		int l = text().length ()  ;
		setSelection       (0, l) ;
		setCursorPosition  (l)	  ;
	}

	/* See if we need to create a helper button. It would be nice	*/
	/* to do this in ::showAs, but that seems to cause a crash	*/
	/* in QScrollView.						*/
	if ((m_showing == KB::ShowAsData) && (m_bHelp == 0) && !m_field->getHelper().isEmpty())
		if (KBHelperReg::helperExists (m_field->getHelper ()))
		{
			m_bHelp	= new QPushButton (getDisplay()->getDisplayWidget()) ;

			m_bHelp->hide		()	;
			m_bHelp->setText	("..")	;
			getDisplay()->addChild	(m_bHelp, 0, 0) ;

			connect
			(	m_bHelp,
				SIGNAL(clicked    ()),
				SLOT  (helpClicked())
			) ;
		}

	if (m_bHelp != 0)
	{
		QRect	g	= TKLineEdit::geometry() ;
		int	bw	= (m_bHelp->sizeHint().width() * 2) / 3 ;

		resize
		(	g.width () - bw,
			g.height()
		)	;

		getDisplay()->moveChild
		(	m_bHelp,
			g.right () - bw,
			g.top   ()
		)	;

		m_bHelp->resize
		(	bw,
			g.height()
		)	;

		m_bHelp->show () ;
	}
}

/*  KBCtrlField								*/
/*  focusOutEvent: Handle focus exit					*/
/*  e		 : QFocusEvent * : Focus exit event			*/
/*  (returns)	 : void		 :					*/

void	KBCtrlField::focusOutEvent
	(	QFocusEvent *e
	)
{
	TKLineEdit::focusOutEvent (e) ;

	if ((m_bHelp != 0) && m_bHelp->isVisible())
	{
		resize (m_field->geometry().size()) ;
		m_bHelp->hide () ;
	}
}

/*  KBCtrlField								*/
/*  giveFocus	: Give focus to the control				*/
/*  (returns)	: void							*/

void	KBCtrlField::giveFocus ()
{
	TKLineEdit::setFocus () ;
}


/*  KBCtrlField								*/
/*  helpClicked	: Helper button clicked					*/
/*  (returns)	: void		:					*/

void	KBCtrlField::helpClicked ()
{
	QString	resval	= KBHelperDlg::run
			  (	m_field->getHelper (),
				text(),
				m_field->getDocRoot()->getLocation()
			  )	;
	if (resval.isNull()) return ;

	KBValue	value	= KBValue (resval, m_field->getFieldType()) ;
	setText (value.getText(m_field->getFormat())) ;

	m_field->userChange (m_field->getBlock()->getCurDRow() + m_drow) ;
}

/*  KBCtrlField								*/
/*  textChangedTo							*/
/*		: Text changed notification				*/
/*  text	: const QString & : New text value			*/
/*  (returns)	: void		  :					*/

void	KBCtrlField::textChangedTo
	(	const QString	&text
	)
{
	if (!m_inSetValue && (m_showing == KB::ShowAsData))
	{
		if (!startUpdate ())
			return	;

		if (m_showing == KB::ShowAsData)
			if (text != getIniValue().getRawText())
				m_field->userChange (m_field->getBlock()->getCurDRow() + m_drow) ;
	}
}


/*  KBCtrlField								*/
/*  write	: Write field 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: Field area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  extra	: int &		: Return extra space			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlField::write
	(	KBWriter	*writer,
		QRect		rect,
		const KBValue	&value,
		bool		fSubs,
		int		&extra
	)
{
	if (writer->asReport())
	{
		new KBWriterText
		(	writer,
			rect,
			m_field->getPalette(true),
			m_field->getFont   (true),
			value.isNull () ?
				QString::null :
				value.getText(m_field->getFormat()),
			m_field->getAlign  ()|Qt::AlignVCenter,
			fSubs
		)	;

		extra	= 0	;
		return	true	;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
}

/*  KBCtrlField								*/
/*  morphText	: Get text for morphed control				*/
/*  (returns)	: QString	: Text					*/

QString	KBCtrlField::morphText ()
{
	return	text()	;
}

/*  KBCtrlField								*/
/*  redraw	: Update to match design state				*/
/*  (returns)	: void		:					*/

void	KBCtrlField::redraw ()
{
	setReadOnly 		 (m_field->isReadOnly()) ;
	setAlignment		 (m_field->getAlign  ()) ;
	m_inputMask.setEnabled   (m_showing == KB::ShowAsData) ;
	m_inputMask.setInputMask (m_field->getAttrVal ("mask")) ;

#if	! __KB_RUNTIME
	if ((m_showing == KB::ShowAsDesign) && (m_drow == 0))
	{
		setEchoMode (TKLineEdit::Normal) ;
		showName    () ;
		return	    ;
	}
#endif

	setEchoMode		 (m_field->isPasswd() ? TKLineEdit::Password : TKLineEdit::Normal) ;
}
