/***************************************************************************
    file	         : kb_query.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QUERY_H
#define	_KB_QUERY_H

#include	"libkbase_exports.h"

/*  KBQuery								*/
/*  -------								*/
/*  This class is the top-level XML node for a query, in the sense of	*/
/*  a query defined inside KBase (and which can then be used from forms	*/
/*  and queries).							*/

class LIBKBASE_API	KBQuery : public KBNode
{
	KBAttrStr	server		;
	bool		changed		;

public	:

	KBQuery (const QDict<QString> &) ;
	KBQuery () ;
virtual~KBQuery () ;

	virtual	KBQuery		*isQuery  () { return this ; }

	virtual	void	printNode	(QString &, int) ;
	void		setServer	(const QString &) ;
	void		getQueryInfo	(QString &, QList<KBTable> &, QList<KBQryExpr> &) ;

	inline	void	setChanged
		(	bool	_changed
		)
	{
		changed	= _changed ;
	}
	inline	bool	getChanged ()
	{
		return	changed	   ;
	}
}	;

#endif	// _KB_QUERY_H
