/***************************************************************************
    file	         : kb_report.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_REPORT_H
#define	_KB_REPORT_H


#include	"kb_reportblock.h"
#include	"kb_layout.h"
#include	"kb_conductor.h"
#include	"kb_docroot.h"
#include	"kb_dom.h"

#include	"libkbase_exports.h"

/*  KBReport								*/
/*  ----------								*/
/*  This node is the root of a particular XML report definition. It	*/
/*  handles things which are global to the report, such as field focus	*/
/*  and field movement and resizing, as well as representing the top-	*/
/*  most block.								*/

class	LIBKBASE_API	KBReport : public KBReportBlock, public KBLayout
{
	Q_OBJECT

	KBAttrStr	m_language	;	/* Script language	*/
	KBAttrStr	m_caption	;	/* Display caption	*/
	KBAttrBool	m_modal		;	/* Form runs modal	*/

	KBAttrStr	m_printer	;	/* Printer to use	*/
	KBAttrBool	m_printdlg	;	/* Alwas show dialog	*/

	KBAttrUInt	m_lMargin	;	/* Left margin		*/
	KBAttrUInt	m_rMargin	;	/* Right margin		*/
	KBAttrUInt	m_tMargin	;	/* Top margin		*/
	KBAttrUInt	m_bMargin	;	/* Bottom margin	*/

	KBDocRoot	m_docRoot	;	/* Common information	*/
	KBDisplay	*m_display	;	/* Top-level display	*/
	KBWriter	*m_writer	;	/* Output writer	*/

	KBValue		m_parentKey	;

protected :

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	() ;
#endif

public	:


	KBReport	(KBLocation &, const QDict<QString> &) ;
	KBReport	(KBLocation &, const QDict<QString> &, bool &) ;
virtual~KBReport	() ;

	virtual	void		printNode	(QString &, int) ;

	virtual	KBReport	*isReport	() { return this	; }
	virtual	KBLayout	*isLayout	() { return this     	; }
	virtual	KBDocRoot	*isDocRoot	() { return &m_docRoot	; }

	virtual	KB::ObjType	objType		() ;

	inline	KBWriter	*getWriter	() { return m_writer	; }
	inline	KBDisplay	*getDisplay	() { return m_display 	; }

#if	! __KB_RUNTIME
	KBPopupMenu		*makeFramerPopup(KBFramer *, Qt::ButtonState *) ;
#endif

	virtual bool		requery		()	;
	void			resize		(QSize)	;

	virtual	KBValue		*getBlockVal	() ;

	void			makeFramerPopup	(KBPopupMenu *, KBFramer  *) ;
	void			margins		(int &, int &, int &, int &) ;
	void			margins		(int &, int &) ;


	KB::ShowRC		showDesign	(QWidget *, QSize &) ;
	KB::ShowRC		showData	(QWidget *, KBWriter *, const QDict<QString> &, const KBValue &, QSize &, bool) ;

	friend	class		KBReportBlock	;
}	;


#if	! __KB_RUNTIME
extern LIBKBASE_API	bool	reportPropDlg
			(	KBReport	*,
				cchar		*,
				QList<KBAttr  > &,
				QList<KBModule> &,
				QList<KBModule> &,
				QList<KBParam > &
			) ;
#endif
#endif	// _KB_REPORT_H
