/***************************************************************************
    file	         : kb_slot.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_SLOT_H
#define	__KB_SLOT_H


#include	"libkbase_exports.h"

#include	<qstring.h>
#include	<qvaluelist.h>
#include	<qobject.h>

#include	"libkbase_exports.h"

#include	"kb_classes.h"
#include	"kb_script.h"


/*  KBSlotLink								*/
/*  ----------								*/
/*  Instances of this class hold slot linkage inforamation:		*/
/*	name	: Used only for identification				*/
/*	target	: Name of target object relative to slots owner		*/
/*	event	: Name of event on target object			*/
/*	enabled	: Whether link is enabled or not			*/

class LIBKBASE_API KBSlotLink
{
	QString		m_name		;
	QString		m_target	;
	QString		m_event		;
	bool		m_enabled	;

public	:

	KBSlotLink	()	;
	KBSlotLink	(const QString &, const QString &, const QString &, bool) ;

	inline	const QString	&name	() const { return m_name    ; }
	inline	const QString	&target	() const { return m_target  ; }
	inline	const QString	&event	() const { return m_event   ; }
	inline	bool		enabled	() const { return m_enabled ; }
}	;


/*  KBSlot								*/
/*  ------								*/
/*  KBObject-derived objects may have slots, which are analagous to QTs	*/
/*  slots. A slot can be associated with events on one or more other	*/
/*  objects, and the slot code will be executed when then event is	*/
/*  triggered.								*/

class LIBKBASE_API	KBSlot	: public QObject
{
	Q_OBJECT

	KBObject		*m_parent	;
	QString			m_name		;
	QValueList<KBSlotLink>	m_linkage	;
	QString			m_code		;

	bool	 		m_disable 	;
	KBScriptCode		*m_script	;

public slots :

	void	eventSignal
		(	KBObject	*,
			const QString	&,
			uint		,
			KBValue		*,
			KB::ScriptRC	&
		)	;

public	:

	KBSlot	(KBObject	*, const QString &)	;
	KBSlot	(KBObject	*, KBSlot	 *)	;

	void	addLinkage	(const QString &, const QString &, const QString &, bool) ;
	void	setCode		(const QString &, bool = false) ;
	void	setParent	(KBObject *) ;
	void	tidy		() ;
	bool	connectLinks	(KBError  &) ;
	void	printNode  	(QString  &,  int) ;


	inline	KBObject	*parent	() { return m_parent ; }
	inline	const QString	&name	() { return m_name   ; }

	friend	class	KBSlotDlg	;
	friend	class	KBSlotListDlg	;
	friend	class	KBSlotListItem	;
}	;

#endif	// __KB_SLOT_H
