/***************************************************************************
    file	         : kb_spinbox.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qcursor.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_sizer.h"
#include	"kb_display.h"
#include	"kb_ctrl.h"
#include	"kb_formblock.h"
#include	"kb_spinbox.h"
#include	"kb_qtspinbox.h"
#include	"kb_nodereg.h"
#include	"kb_writer.h"

#if		! __KB_RUNTIME
#include	"kb_itemdlg.h"
#endif


/*  KBSpinBox								*/
/*  KBSpinBox	: Constructor for simple form field			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBNode	:					*/

KBSpinBox::KBSpinBox
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBItem	(parent, "KBSpinBox",	"expr",  aList),
	fgcolor	(this,   "fgcolor",	aList),
	bgcolor	(this,   "bgcolor",	aList),
	nullOK	(this,   "nullok",	aList, KF_FORM  ),
	morph	(this,   "morph",	aList, KF_FORM  )
{
#if	! __KB_RUNTIME
	if (ok != 0)
	{
		KBItemPropDlg iDlg (this, "Spinbox", attribs) ;
		if (!iDlg.exec())
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true	;
	}

#endif
	spinbox	= 0	;
}

/*  KBSpinBox								*/
/*  KBSpinBox	: Constructor for simple form field			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _spinbox	: KBSpinBox *	: Extant field				*/
/*  (returns)	: KBSpinBox	:					*/

KBSpinBox::KBSpinBox
	(	KBNode		*_parent,
		KBSpinBox	*_spinbox
	)
	:
	KBItem	(_parent,"expr",	_spinbox),
	fgcolor	(this,   "fgcolor",	_spinbox),
	bgcolor	(this,   "bgcolor",	_spinbox),
	nullOK	(this,   "nullok",	_spinbox, KF_FORM  ),
	morph	(this,   "morph",	_spinbox, KF_FORM  )
{
	spinbox	= 0	;
}

/*  KBSpinBox								*/
/*  ~KBSpinBox	: Destructor for simple form field			*/
/*  (returns)	:		:					*/

KBSpinBox::~KBSpinBox ()
{
}

/*  KBSpinBox								*/
/*  makeCtrl	: Make a field control					*/
/*  morph	: bool		: Get morped control			*/
/*  (returns)	: KBControl *	: New control				*/

KBControl
	*KBSpinBox::makeCtrl
	(	uint		drow
	)
{
	return	spinbox	= new KBCtrlSpinBox (getDisplay(), this, drow) ;
}

/*  KBSpinBox								*/
/*  userChange	: Selection changed notification			*/
/*  qrow	: uint		: Query row number			*/
/*  (returns)	: void		:					*/

void	KBSpinBox::userChange
	(	uint	qrow
	)
{
	KBItem::userChange (qrow) ;
}

/*  KBSpinBox								*/
/*  isMorphed	: Test if field is morphed				*/
/*  (returns)	: bool		: Morphed				*/

bool	KBSpinBox::isMorphing ()
{
	return	morph.getBoolValue() ;
}

/*  KBSpinBox								*/
/*  replicate	: Replicate this field					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New field node			*/

KBNode	*KBSpinBox::replicate
	(	KBNode	*_parent
	)
{
	return	new KBSpinBox (_parent, this) ;
}

#if	! __KB_RUNTIME
/*  KBSpinBox								*/
/*  propertyDlg	: Show property dialog					*/
/*  iniAttr	: cchar *	: Initial attribute			*/
/*  (returns)	: bool		: Success				*/

bool	KBSpinBox::propertyDlg
	(	cchar	*iniAttr
	)
{
	KBItemPropDlg iDlg (this, "Spinbox", attribs, iniAttr) ;
	if (!iDlg.exec()) return false ;

	updateProps ()	;
	return true     ;
}
#endif

NEWNODE(SpinBox, __TR("New &Spinbox"), KF_FORM|KF_BLOCK|KF_DATA)
