/***************************************************************************
    file	         : kb_widgettree.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<qobjectlist.h>
#include	<qwidget.h>

#include "libkbase_exports.h"


void	LIBKBASE_API	printWidgetTree
	(	QWidget		*widget,
		uint		indent,
		int		maxDepth
	)
{
	fprintf	(stderr, "%*s%s (%s) %s (%d,%d)(%d,%d)\n",
			 indent,
			 "",
			 widget->className(),
			 widget->name("noname"),
			 widget->isVisible() ? "visible" : "hidden ",
			 widget->x(),
			 widget->y(),
			 widget->width(),
			 widget->height()
		) ;

	if (maxDepth == 0) return ;

	QObjectList *children = widget->queryList("QWidget", 0, true, false) ;
	if (children == 0) return ;

	QObjectListIt iter (*children) ;
	QObject	      *obj ;

	while ((obj = iter.current()) != 0)
	{	*++iter ;
		printWidgetTree ((QWidget *)obj, indent + 2, maxDepth - 1) ;
	}

	delete	children ;
}
