/***************************************************************************
    file	         : tkc_tkemapper.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TKC_TKEMAPPER_H
#define	__TKC_TKEMAPPER_H

#include	<qobject.h>
#include	<qstring.h>
#include	<qintdict.h>
#include	<qvaluelist.h>
#include	<qguardedptr.h>
#include	<qtimer.h>
#include	<qdialog.h>
#include	<qsimplerichtext.h>

#include 	"kb_dictionary.h"

#include	"tktexteditor.h"
#include	"editordialogs.h"

#include	"tkc_keymapper.h"

#include	"libkbase_exports.h"

/*  TKCTKEHelper							*/
/*  ------------							*/
/*  This class is used to display help popups, in the manner of the	*/
/*  QWhatsThis helper popups.						*/

class	LIBKBASE_API	TKCTKEHelper : public QWidget
{
	Q_OBJECT
	QSimpleRichText	doc	;

protected :

	virtual void	paintEvent	(QPaintEvent *)	  ;

public	:

	TKCTKEHelper	(TKTextEditor *, const QString &) ;
}	;


/*  TKCTKEHelpReplace							*/
/*  -----------------							*/
/*  Modal dialog wrapper round the FindReplaceDialog widget, needed	*/
/*  since some use of TKTextEditor is inside modal widgets. Also hooks	*/
/*  directory to an editor.						*/

class LIBKBASE_API	TKCTKEFindReplace : public QDialog
{
	Q_OBJECT

	FindReplaceDialog		m_fr	;
	QGuardedPtr<TKTextEditor>	m_editor;

protected :

	void	showEvent	(QShowEvent *)	;

protected slots :

	void	slotClose	()	;
	void	slotFind	()	;
	void	slotFindNext	()	;
	void	slotReplace	()	;
	void	slotReplaceAll	()	;

public	:


	TKCTKEFindReplace	()	;

	int	exec		(TKTextEditor *, bool) ;
}	;


/*  TKCTKEMapper								*/
/*  ----------								*/
/*  Implementation of tke TKCKeyMapper for use with the TKTextEditor	*/
/*  text editor.							*/

class	LIBKBASE_API	TKCTKEMapper : public TKCKeyMapper
{
	Q_OBJECT

	TKTextEditor		*m_editor	;
	QGuardedPtr<QWidget>	m_helper	;
	int			m_helperLine	;
	bool			m_helperShown	;

	bool			filterEditor	(QEvent *)	   ;
	void			showHelper	(const QString &)  ;
	void			hideHelper	()		   ;

protected slots :

	void			checkChangeLine	()		   ;
	void			helperShowing	()		   ;

protected :

	virtual	bool		useAtOuterLevel	(int, bool) ;
	virtual int		codeToCode	(const QString &) ;
	virtual	bool		helper		(int, const QString &) ;
	virtual	bool		function	(int, const QString &) ;

public	:

	TKCTKEMapper	(TKTextEditor *) ;
       ~TKCTKEMapper	()	;

	bool	eventFilter	(QObject *, QEvent *) ;

	enum	Action
	{	NoAction,
		StartOfLine,
		EndOfLine,
		StartOfDoc,
		EndOfDoc,
		NextWord,
		PreviousWord,
		DelWordLeft,
		DelWordRight,
		DelLine,
		Cut,
		Copy,
		Paste,
		ToLower,
		ToUpper,
		ScrollUp,
		ScrollDown,
		Undo,
		Redo,
		SearchForward,
		SearchBack
	}	;
}	;


#endif	// __TKC_TKEMAPPER_H
