/***************************************************************************
    file	         : tk_filedialog.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#include	"tk_filedialog.h"

KBFileDialog::KBFileDialog
	(	const QString	&startDir,
		const QString	&filter,
		QWidget		*parent,
		const char	*name,
		bool		modal
	)
	:
	KFileDialog (startDir, filter, parent, name, modal)
{
}

QString	KBFileDialog::getOpenFileName
	(	const QString	&startDir,
		const QString	&filter,
		QWidget		*parent,
		const QString	&caption
	)
{
	return	KFileDialog::getOpenFileName
		(	startDir,
			filter,
			parent,
			caption
		)	;
}

QString	KBFileDialog::getSaveFileName
	(	const QString	&startDir,
		const QString	&filter,
		QWidget		*parent,
		const QString	&caption
	)
{
	return	KFileDialog::getSaveFileName
		(	startDir,
			filter,
			parent,
			caption
		)	;
}

QString	KBFileDialog::getExistingDirectory
	(	const QString	&startDir,
		const QString	&caption
	)
{
	return	KFileDialog::getExistingDirectory
		(	startDir,
			0,
			caption
		)	;
}

void	KBFileDialog::setMode
	(	KBFileDialog::KBMode	mode
	)
{
	switch (mode)
	{
		case KBFileDialog::Directory	:
			KFileDialog::setMode
			(
				KFile::Directory
			)	;
			break	;

		case KBFileDialog::ExistingFile :
			KFileDialog::setMode
			(
				(KFile::Mode)(KFile::ExistingOnly | KFile::File)
			)	;
			break	;

		case KBFileDialog::AnyFile	:
			KFileDialog::setMode
			(
				KFile::File
			)	;
			break	;

		case KBFileDialog::ExistingFiles:
			KFileDialog::setMode
			(
				(KFile::Mode)(KFile::ExistingOnly | KFile::Files)
			)	;
			break	;

		default	:
			break	;
	}
}

