/***************************************************************************
    file	         : kb_kdepart.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qcursor.h>
#include	<qlineedit.h>
#include	<qfile.h>

#include	<kuserprofile.h>
#include	<kmimetype.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_sizer.h"
#include	"kb_display.h"
#include	"kb_ctrl.h"
#include	"kb_formblock.h"
#include	"kb_kdepart.h"
#include	"kb_qtkdepart.h"
#include	"kb_kdepartdlg.h"
#include	"kb_nodereg.h"
#include	"kb_writer.h"
#include	"kb_dom.h"

#include	"kb_locator.h"


static	QDict<KBKDEPartSpec> partDict ;


void	KBKDEPart::loadPartList ()
{
	QString	list	= locateFile ("appdata", "services/kdeparts.lst") ;
	if (list.isEmpty())
	{
		fprintf
		(	stderr,
			"KBKDEPart::loadPartList: cannot locate [kdeparts.lst]\n"
		)	;
		return	;
	}


	QFile	file	(list) ;
	if (!file.open (IO_ReadOnly))
	{
		fprintf
		(	stderr,
			"KBKDEPart::loadPartList: cannot open [%s]\n",
			(cchar *)list
		)	;
		return	;
	}

	QDomDocument	doc ;
	if (!doc.setContent (&file))
	{
		fprintf
		(	stderr,
			"KBKDEPart::loadPartList: cannot parse [%s]\n",
			(cchar *)list
		)	;
		return	;
	}

	DOMITER_BEGIN(doc.documentElement(), "part", part)
	{
		KBKDEPartSpec *spec = new KBKDEPartSpec ;

		spec->m_tag		= part.attribute("tag"        ) ;
		spec->m_description	= part.attribute("description") ;
		spec->m_mime	  	= part.attribute("mimetype"   ) ;
		spec->m_constraint	= part.attribute("constraint" ) ;

		partDict.insert (spec->m_tag, spec) ;
	}
	DOMITER_END

	fprintf
	(	stderr,
		"KBKDEPart::loadPartList: loaded %d specifications\n",
		partDict.count()
	)	;
}

/*  ------------------------------------------------------------------  */

/*  KBKDEPart								*/
/*  KBKDEPart	: Constructor for KDE part embedder			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBNode	:					*/

KBKDEPart::KBKDEPart
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBItem	 	(parent, "KBKDEPart",	"expr", aList),
	m_frame	 	(this,	 "frame",		aList),
	m_typeTag	(this,	 "typetag",		aList, KAF_GRPFORMAT),
	m_dbData	(this,	 "dbdata",		aList, KAF_GRPDATA),
	m_follow	(this,	 "follow",		aList, KAF_GRPDATA)
{
	if (partDict.count() == 0) loadPartList () ;

	rdonly  .setValue (true) ; remAttr (&rdonly  ) ;
	noupdate.setValue (true) ; remAttr (&noupdate) ;

#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!::kdePartPropDlg (this, "KDEPart", attribs))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true	;
	}
#endif

	m_factory = 0 ;
}

/*  KBKDEPart								*/
/*  KBKDEPart	: Constructor for KDE part embedder			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _memo	: KBKDEPart *	: Extant memo				*/
/*  (returns)	: KBKDEPart	:					*/

KBKDEPart::KBKDEPart
	(	KBNode		*_parent,
		KBKDEPart	*_kdePart
	)
	:
	KBItem	 	(_parent,"expr",	_kdePart),
	m_frame	 	(this,	 "frame",	_kdePart),
	m_typeTag	(this,	 "typetag",	_kdePart, KAF_GRPFORMAT),
	m_dbData	(this,	 "dbdata",	_kdePart, KAF_GRPDATA),
	m_follow	(this,	 "follow",	_kdePart, KAF_GRPDATA)
{
	rdonly  .setValue (true) ; remAttr (&rdonly  ) ;
	noupdate.setValue (true) ; remAttr (&noupdate) ;

	m_factory = 0 ;
}

/*  KBKDEPart								*/
/*  ~KBKDEPart	: Constructor for KDE part embedder			*/
/*  (returns)	:		:					*/

KBKDEPart::~KBKDEPart ()
{
}

/*  KBKDEPart								*/
/*  makeCtrl	: Make a field control					*/
/*  drow	: uint		: Display row number			*/
/*  (returns)	: KBControl *	: New control				*/

KBControl *KBKDEPart::makeCtrl
	 (	uint		drow
	 )
{
	return	new KBCtrlKDEPart (getDisplay(), this, drow) ;
}

/*  KBKDEPart								*/
/*  checkValid	: Check whether value can be saved in database		*/
/*  value	: const QString & : Putative value			*/
/*  allowNull	: bool		  : Ignore not-null check		*/
/*  (returns)	: bool		  : True if OK				*/

bool	KBKDEPart::checkValid
	(	const QString	&,
		bool		
	)
{
	return	true	;
}

/*  KBKDEPart								*/
/*  getValue	: Get value						*/
/*  qrow	: uint		: Query row				*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBKDEPart::getValue
	(	uint	
	)
{
	return	KBValue	() ;
}

/*  KBKDEPart								*/
/*  replicate	: Replicate this field					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New field node			*/

KBNode	*KBKDEPart::replicate
	(	KBNode	*_parent
	)
{
	return	new KBKDEPart (_parent, this) ;
}

/*  KBKDEPart								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBKDEPart::showAs
	(	KB::ShowAs	mode
	)
{
	m_factory = 0 ;

	if (mode == KB::ShowAsData)
	{
		KBKDEPartSpec	*spec	= partDict.find (m_typeTag.getValue()) ;
		if (spec == 0)
		{
			KBError::EError
			(	QString(TR("Cannot locate any part specification for %1"))
					.arg(m_typeTag.getValue()),
				QString::null,
				__ERRLOCN
			)	;

			KBItem::showAs (mode) ;
			return	;
		}

		const QString	&mime  = spec->m_mime	   ;
		const QString	&cons  = spec->m_constraint;

		KTrader::OfferList
			 offers = KTrader::self()->query (mime, cons) ;

		if (offers.count() == 0)
		{
			KBError::EError
			(	QString(TR("Cannot locate any parts for %1"))
					.arg(spec->m_description),
				QString(TR("MimeType=%1 Constraint=%2"))
					.arg(mime)
					.arg(cons),
				__ERRLOCN
			)	;

			KBItem::showAs (mode) ;
			return	;
		}

		KService::Ptr	service	 = offers.first() ;

		m_factory = KLibLoader::self()->factory(service->library()) ;
		if (m_factory == 0)
		{
			KBError::EError
			(	QString(TR("Cannot create part factory for %1"))
					.arg(spec->m_description),
				QString(TR("MimeType=%1 Constraint=%2"))
					.arg(mime)
					.arg(cons),
				__ERRLOCN
			)	;

			KBItem::showAs (mode) ;
			return	;
		}

		fprintf
		(	stderr,
			"KBKDEPart::showAs: [%s][%s][%s][%s]\n",
			(cchar *)mime,
			(cchar *)cons,
			(cchar *)service->library(),
			(cchar *)service->name   ()
		)	;

		m_service = service->name()   ;
	}

	KBItem::showAs (mode) ;
}


KParts::ReadOnlyPart *KBKDEPart::readOnlyPart
	(	QWidget		*parent
	)
{
	if (m_factory != 0)
		return	(KParts::ReadOnlyPart *)m_factory->create
					(	parent,
						m_service,
						"KParts::ReadOnlyPart"
					)	;

	return	0 ;
}

#if	! __KB_RUNTIME

const QDict<KBKDEPartSpec> &KBKDEPart::getPartDict ()
{
	return	partDict	;
}

/*  KBKDEPart								*/
/*  propertyDlg	: Show property dialog					*/
/*  iniAttr	: cchar *	: Initial attribute			*/
/*  (returns)	: bool		: Success				*/

bool	KBKDEPart::propertyDlg
	(	cchar	*iniAttr
	)
{
	if (!::kdePartPropDlg (this, "KDEPart", attribs, iniAttr)) return false ;

	updateProps  ()	;
	redraw	     () ;
	return true     ;
}
#endif

NEWNODE(KDEPart, __TR("New &KDE Part"), KF_FORM|KF_BLOCK|KF_DATA|KF_EXTRA)


