/***************************************************************************
    file	         : kb_kdepart.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_KDEPART_H
#define	_KB_KDEPART_H

#include	"libkbase_exports.h"

#include	"tktextmanager.h"

#include	"kb_classes.h"
#include	"kb_item.h"
#include	"kb_attrframe.h"

#include	<kparts/part.h>
#include	<klibloader.h>
#include	<ktrader.h>


struct	KBKDEPartSpec
{
	QString		m_tag		;
	QString		m_description	;
	QString		m_mime		;
	QString		m_constraint	;

	int		m_combo		;
}	;


/*  KBKDEPart								*/
/*  ---------								*/
/*  This class is used in order to create a control that embeds a KDE	*/
/*  part.								*/

class	LIBKBASE_API	KBKDEPart : public KBItem
{
	KBAttrFrame	m_frame	    ;	/* Frame style			*/
	KBAttrStr	m_typeTag   ;
	KBAttrBool	m_dbData    ;
	KBAttrBool	m_follow    ;

	KLibFactory	*m_factory  ;
	QString		m_service   ;

	static	void		loadPartList	() ;

protected :

	virtual	KBControl	*makeCtrl	(uint   ) ;

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	(cchar *) ;
#endif

public	:

	KBKDEPart	(KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBKDEPart	(KBNode  *, KBKDEPart *) ;
virtual~KBKDEPart	() ;

	virtual	KBNode		*replicate	(KBNode *) ;
	virtual	KBValue		getValue	(uint)	   ;

	virtual	void		showAs		(KB::ShowAs) ;

	bool			checkValid	(const QString &, bool) ;

	inline	bool	valueIsData ()
	{
		return	m_dbData .getBoolValue() ;
	}
	inline	bool	follow	    ()
	{
		return	m_follow .getBoolValue() ;
	}

	KParts::ReadOnlyPart	*readOnlyPart	(QWidget *);

	static	const QDict<KBKDEPartSpec>	&getPartDict () ;
}	;



#if	! __KB_RUNTIME
extern LIBKBASE_API	bool	memoPropDlg
			(	KBMemo		*,
				cchar		*,
				QList<KBAttr>	&,
				cchar		* = 0
			)	;
#endif
#endif	// _KB_KDEPART_H
