/***************************************************************************
    file	         : kb_kdepartdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qframe.h>
#include	<qmessagebox.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"

#include	"kb_attr.h"
#include	"kb_block.h"
#include	"kb_item.h"


#ifndef 	_WIN32
#include 	"kb_kdepartdlg.moc"
#else
#include 	"kb_kdepartdlg.h"
#endif

#include	"libkbase_exports.h"


class	LIBKBASE_API	KBAttrItemPart : public KBAttrItem
{
public	:


	KBAttrItemPart	(KBAttr *)	;
	virtual ~KBAttrItemPart ()	;

	virtual	QString	displayValue	() ;
}	;

KBAttrItemPart::KBAttrItemPart
	(	KBAttr		*attr
	)
	:
	KBAttrItem	(attr)
{
}

KBAttrItemPart::~KBAttrItemPart ()
{
}

QString	KBAttrItemPart::displayValue ()
{
	KBKDEPartSpec *spec = KBKDEPart::getPartDict().find(m_value) ;
	return	spec == 0 ? m_value : spec->m_description ;
}


/*  ------------------------------------------------------------------  */

/*  KBKDEPartPropDlg							*/
/*  KBKDEPartPropDlg							*/
/*		: Constructor for part properties dialog		*/
/*  item	: KBKDEPart *	   : Parent item			*/
/*  caption	: const char *     : Dialog box caption			*/
/*  attribs	: QList<KBAttr>&   : List of attributes			*/
/*  apply	: bool		   : Show apply button			*/
/*  iniAttr	: cchar *	   : Initial attribute			*/
/*  (returns)	: KBKDEPartPropDlg :					*/

KBKDEPartPropDlg::KBKDEPartPropDlg
	(	KBKDEPart	*part,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
	:
	KBItemPropDlg	(part, caption, attribs, iniAttr),
	m_part		(part)
{
}

/*  KBKDEPartPropDlg							*/
/*  ~KBKDEPartPropDlg							*/
/*		: Destructor for part properties dialog			*/
/*  (returns)	: void	:						*/

KBKDEPartPropDlg::~KBKDEPartPropDlg ()
{
}


/*  KBKDEPartPropDlg							*/
/*  getAttrItem	: Get attribute item for attribute			*/
/*  attr	: KBAttr *	: Attribute				*/
/*  (returns)	: KBAttrItem *	: Associated attribute item		*/

KBAttrItem
	*KBKDEPartPropDlg::getAttrItem
	(	KBAttr	*attr
	)
{
	if (attr->getName() == "typetag")
		return	new KBAttrItemPart (attr) ;

	return	KBItemPropDlg::getAttrItem (attr) ;
}

/*  KBKDEPartPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBKDEPartPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName	= item->attr()->getName () ;

	if (aName == "typetag")
	{
		QDictIterator<KBKDEPartSpec> iter (KBKDEPart::getPartDict ()) ;

		KBKDEPartSpec	*spec	;
		KBKDEPartSpec	*curr	= 0 ;

		comboBox.clear	()	;

		while ((spec = iter.current()) != 0)
		{
			spec->m_combo = comboBox.count() ;
			if (spec->m_tag == item->value()) curr = spec ;

			comboBox.insertItem (spec->m_description) ;
			iter	+= 1 ;
		}

		if (curr != 0) comboBox.setCurrentItem (curr->m_combo) ;

		comboBox.show () ;
		return	true ;
	}

	return	KBItemPropDlg::showProperty (item) ;
}

/*  KBKDEPartPropDlg							*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBKDEPartPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	if (aName == "typetag")
	{
		QDictIterator<KBKDEPartSpec> iter (KBKDEPart::getPartDict ()) ;
		KBKDEPartSpec	*spec	;

		while ((spec = iter.current()) != 0)
		{
			if (spec->m_combo == comboBox.currentItem())
			{
				setProperty (item, spec->m_tag) ;
				return true ;
			}

			iter	+= 1 ;
		}

		setProperty (item, "") ;
		return	true ;
	}

	return	KBItemPropDlg::saveProperty (item) ;
}

/*  KBKDEPartPropDlg							*/
/*  propertyOK	: Check if property is OK				*/
/*  attr	: KBAttrItem *	: Attribute				*/
/*  (returns)	: bool		: True if OK				*/

bool	KBKDEPartPropDlg::propertyOK
	(	KBAttrItem	*item
	)
{
	return	KBItemPropDlg::propertyOK (item) ;
}

/*  ------------------------------------------------------------------  */

/*  kdePartPropDlg: Run the part properties dialog			*/
/*  part	  : KBKDEPArt *	  : Parent part				*/
/*  caption	  : const char *  : Dialog box caption			*/
/*  attribs	  : QList<KBAttr>&: List of attributes			*/
/*  iniAttr	  : cchar *	  : Initial attribute			*/
/*  (returns)	  : bool	  : Success				*/

bool 	LIBKBASE_API kdePartPropDlg
	(	KBKDEPart	*part,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
{
	KBKDEPartPropDlg pDlg (part, caption, attribs, iniAttr) ;
	return	pDlg.exec () ;
}
