/***************************************************************************
    file	         : kb_qtkdepart.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QTKDEPART_H
#define	_KB_QTKDEPART_H

#include	<qlayout.h>
#include	<qlabel.h>

#include	<kparts/part.h>
#include	<ktempfile.h>

#include	"kb_ctrl.h"



class		KBKDEPart	;
class		KBCtrlKDEPart	;

/*  ------------------------------------------------------------------  */

/*  KBCtrlKDEPart								*/
/*  ----------								*/
/*  Wrapper class for memi edit control					*/

class	LIBKBASE_API	KBCtrlKDEPart : public QLabel, public KBControl
{
	Q_OBJECT

	KBKDEPart		*m_part		;
	QVBoxLayout		*m_layout	;

	KParts::ReadOnlyPart	*m_roPart	;
	KTempFile 		*m_tempFile	;

	void			loadValueData	(const KBValue &) ;
	void			loadURL		(const KURL &) ;

protected slots :

        virtual void    	giveFocus	() 	;
	virtual	bool		eventFilter	(QObject *, QEvent *) ;
	void			openURLRequest	(const KURL &) ;

public	:

		KBCtrlKDEPart	(KBDisplay *, KBKDEPart *, uint) ;
	virtual~KBCtrlKDEPart	() ;

	virtual	void		showName	()	;
	virtual	void		setPalette	(const QPalette *)	;
	virtual	void		setFont		(const QFont    *)	;
	virtual	void		showAs		(KB::ShowAs) ;
	virtual	void		redraw		() 	;
	virtual	void		setValue	(const KBValue &) ;
	virtual	KBValue		getValue	()	;
	virtual	void		clearValue	(bool)	;
	virtual	bool		changed		()	;
	virtual	bool		isEmpty		()	;
	virtual	bool		isValid		(bool)	;
	virtual	bool		write		(KBWriter *, QRect, const KBValue &, bool, int &) ;

	virtual	bool		viewSetFocusOK	()	;

	virtual	QWidget		*topWidget	()	;
	virtual	QWidget		*mainWidget	()	;

	SETFOCUS
	SIZEHINT
}	;


#endif	// _KB_QTKDEPART_H
