/***************************************************************************
    file	         : tk_config.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TKC_CONFIG_H
#define	__TKC_CONFIG_H

#include	<qstring.h>
#include	<qsize.h>
#include	<qvaluelist.h>

#include "libtkkde_exports.h"

class	QSettings	;

class LIBTKKDE_API TKConfig
{
	QString		m_vendor	;
	QString		m_app		;
	QString		m_group		;
	QString		m_prefix	;
	QSettings	*m_config	;

	QString		makeKey	(const QString &) const ;

public	:

	TKConfig ()	;

	void		setGroup		(const QString &)			  ;
	void		writeEntry		(const QString &, const QString &)	  ;
	void		writeEntry		(const QString &, int)			  ;
	void		writeEntry		(const QString &, unsigned  int)	  ;
	void		writeEntry		(const QString &, const QSize &)	  ;
	void		writeEntry		(const QString &, const QValueList<int>&) ;
	void		writeEntry		(const QString &, const QStringList &, char = ',') ;

	QString		readEntry		(const QString &, const QString & = QString::null) ;
	unsigned int	readUnsignedNumEntry	(const QString &, unsigned int  = 0) const ;
	int		readNumEntry		(const QString &,	   int  = 0) const ;
	bool		readBoolEntry		(const QString &, bool = false	   ) const ;
	QSize		readSizeEntry		(const QString &, const QSize * = 0) const ; 
	QValueList<int>	readIntListEntry	(const QString &) const ;
	QStringList	readListEntry		(const QString &, char = ',') const ;

	void		sync			() ;

	void		setVendor		(const char *)	;
	void		setApplication		(const char *)	;
	void		insertSearchPath	(int, const QString &) ;

	static	TKConfig	*getConfig () ;
}	;


#endif	// __TKC_CONFIG_H
