/***************************************************************************
    file	         : tk_mainwindow.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qobjectlist.h>
#include	<qtoolbutton.h>
#include	<qlayout.h>

#include	"tk_toolbutton.h"

#ifndef 	_WIN32
#include	"tk_mainwindow.moc"
#else
#include	"tk_mainwindow.h"
#endif


/*  TKMainWindow							*/
/*  TKMainWindow: Constructor for main window class			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  name	: const char *	: Object name				*/
/*  flags	: QFlags	: Widget flags				*/
/*  (returns)	: TKMainWindow	:					*/

TKMainWindow::TKMainWindow
	(	QWidget		*parent,
		const char	*name,
		WFlags		flags
	)
	:
	QMainWindow	(parent, name, flags)
{
	m_toolBar	= 0	;
	m_menuBar	= 0	;
	m_dummy		= 0	;
	m_inShow	= false	;
	m_shown		= false	;
}

/*  TKMainWindow							*/
/*  menuBar	: Get the menu bar					*/
/*  (returns)	: TKMenuBar *	: Menu bar or null			*/

TKMenuBar
	*TKMainWindow::menuBar ()
{
#if	! __KB_EMBEDDED
	if (m_menuBar == 0)
	{
		m_menuBar	= new TKMenuBar (this) ;
	}
#endif
	return	m_menuBar ;
}

/*  TKMainWindow							*/
/*  toolBar	: Get the menu bar					*/
/*  (returns)	: QToolBar *	: Tool bar			*/

QToolBar*TKMainWindow::toolBar ()
{
	if (m_toolBar == 0)
	{
		m_toolBar = new QToolBar (this) ;
		addToolBar (m_toolBar) ;

#if	__KB_EMBEDDED
		m_fileMenu = new TKActionMenu
			     (		"Menu",
			     		0,
			     		"tk_dummy_button"
			     )	;
		m_fileMenu->setIcon ("menu") ;
		m_dummy	= m_fileMenu ;
#else
		m_dummy	= new TKAction
			  (	0,
				"blank",
				0,
				0,
				0,
				0,
				"tk_dummy_button"
			  )	;

		m_dummy->setEnabled (false)	;
#endif

		m_dummy->plug (m_toolBar)	;
	}

	return	m_toolBar ;
}

/*  TKMainWindow:							*/
/*  createGUI	: Create a GUI for a specified part in this window	*/
/*  part	: TKPart *	: Part in question			*/
/*  (returns)	: void		:					*/

void	TKMainWindow::createGUI
	(	TKPart		*part
	)
{
//	fprintf	(stderr, "TKMainWindow::createGUI [%d]\n", part) ;

	setUpdatesEnabled    (false) ;

	if (menuBar() != 0)
	{
		menuBar()->setFrozen (true ) ;
		menuBar()->clear     () ;
	}

	if (toolBar()->children())
	{
		QObjectListIt iter  (*toolBar()->children()) ;
		QObject	      *obj  ;
		while ((obj = iter.current()) != 0)
		{	iter += 1 ;
			if (obj->isWidgetType())
			{	if (qstrcmp("qt_dockwidget_internal", obj->name()) == 0) continue ;
				if (qstrcmp("tk_dummy_button",	      obj->name()) == 0) continue ;
				delete	obj ;
			}
		}
	}		

#if	__KB_EMBEDDED
	m_fileMenu->popup()->clear() ;
	buildGUI (m_fileMenu->popup(), toolBar()) ;
	if (part != 0) part->buildGUI (m_fileMenu->popup(), toolBar()) ;
#else

	buildGUI (menuBar(), toolBar()) ;
	if (part != 0) part->buildGUI (menuBar(), toolBar()) ;
#endif
	toolBar()->setStretchableWidget(new QWidget(toolBar())) ;

	if (menuBar() != 0) menuBar()->setFrozen (false) ;
	setUpdatesEnabled   (true ) ;
}

/*  TKMainWindow							*/
/*  menuBarHeight: Get the height of the menu bar			*/
/*  (returns)	 : int		: Height				*/

int	TKMainWindow::menuBarHeight ()
{
	return	menuBar() == 0 ? 0 : menuBar()->height() ;
}

/*  TKMainWindow							*/
/*  toolBarHeight: Get the height of the tool bar			*/
/*  (returns)	 : int		: Height				*/

int	TKMainWindow::toolBarHeight ()
{
	return	toolBar() == 0 ? 0 : toolBar()->height() ;
}

/*  TKMainWindow							*/
/*  queryClose	: Window close versification				*/
/*  (returns)	: bool		:					*/

bool	TKMainWindow::queryClose ()
{
	/* This routine only exists to provide compatability with	*/
	/* KMainWindow.							*/
	return	true	;
}

bool	TKMainWindow::queryExit ()
{
	/* This routine only exists to provide compatability with	*/
	/* KMainWindow.							*/
	return	true	;
}

/*  TKMainWindow							*/
/*  closeEvent	: Handle a close event					*/
/*  e		: QCloseEvent *	: The event in question			*/
/*  (returns)	: bool		:					*/

void	TKMainWindow::closeEvent
	(	QCloseEvent	*e
	)
{
	if (queryClose() && queryExit())
		e->accept () ;
}

/*  TKMainWindow							*/
/*  show	: Local handling of the show function			*/
/*  (returns)	: void		:					*/

void	TKMainWindow::show ()
{
#if	__KB_EMBEDDED
	/* In the embedded window, we always want to show top-level	*/
	/* windows full sized the first time they are shown, whatever	*/
	/* may have been set by the caller.				*/
	if (!m_inShow && !m_shown)
	{
		m_inShow  = true	 ;
		showMaximized ()	 ;
		m_maxGeom = geometry ()	 ;
		m_inShow  = false	 ;
		m_shown	  = true	 ;
		return	  ;
	}
#endif
	QMainWindow::show	     ()  ;
	QMainWindow::raise 	     ()  ;
	QMainWindow::setActiveWindow ()  ;
}

/*  TKMainWindow							*/
/*  show	: Local handling of the show function			*/
/*  reset	: bool		: Reset geometry			*/
/*  (returns)	: void		:					*/

void	TKMainWindow::show
	(	bool	reset
	)
{
#if	__KB_EMBEDDED
	if (reset && m_shown)
	{
		setGeometry (m_maxGeom) ;
		return	;
	}
#endif
	show () ;
}

void	TKMainWindow::showMenuToolBars
	(	bool	showMenuBar,
		bool	showToolBar
	)
{
	if (menuBar() != 0)
		if (showMenuBar)
			menuBar()->show() ;
		else	menuBar()->hide() ;

	if (toolBar() != 0)
		if (showToolBar)
			toolBar()->show() ;
		else	toolBar()->hide() ;
}