/*
    Copyright (C) 2001-2002 by theKompany.com <www.thekompany.com>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    See COPYING.GPL file.

    In addition, as a special exception, theKompany.com gives permission
    to link the code of this program with the tkwidgets library (or with
    modified versions of tkwidgets that use the same license as tkwidgets),
    and distribute linked combinations including the two.  You must obey
    the GNU General Public License in all respects for all of the code used
    other than tkwidgets.  If you modify this file, you may extend this
    exception to your version of the file, but you are not obligated to do so.
    If you do not wish to do so, delete this exception statement from your
    version.

    This license grants you the ability to use tkwidgets with Rekall only
    and may not be used outside of Rekall.
    See also http://www.rekall.a-i-s.co.uk/products/license.txt for details.
*/


#ifndef _WIN32
#include "editordialogs.moc"
#else
#include "editordialogs.h"
#endif

#include <qlayout.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qlineedit.h>

FindReplaceDialog::FindReplaceDialog(QWidget *parent, const char *name)
: QWidget(parent, name)
{
  layout = 0;

  findBox = new QComboBox(true, this);
  findBox->setMaxCount(7);
  findBox->setDuplicatesEnabled(false);

  replaceBox = new QComboBox(true, this);
  replaceBox->setMaxCount(7);
  replaceBox->setDuplicatesEnabled(false);

  bFind = new QPushButton(tr("Find"), this);
  bNext = new QPushButton(tr("Next"), this);
  bReplace = new QPushButton(tr("Replace"), this);
  bReplaceAll = new QPushButton(tr("Replace All"), this);

  connect(bFind, SIGNAL(clicked()), SIGNAL(find()));
  connect(bFind, SIGNAL(clicked()), SLOT(saveText()));
  connect(bNext, SIGNAL(clicked()), SIGNAL(next()));
  connect(bNext, SIGNAL(clicked()), SLOT(saveText()));
  connect(bReplace, SIGNAL(clicked()), SIGNAL(replace()));
  connect(bReplace, SIGNAL(clicked()), SLOT(saveText()));
  connect(bReplaceAll, SIGNAL(clicked()), SIGNAL(replaceAll()));
  connect(bReplaceAll, SIGNAL(clicked()), SLOT(saveText()));

  connect(findBox->lineEdit(), SIGNAL(returnPressed()), SIGNAL(next())) ;
  connect(replaceBox->lineEdit(), SIGNAL(returnPressed()), SIGNAL(replace())) ;

  bWholeWord = new QPushButton(tr("Whole Word"), this);
  bMatcgCase = new QPushButton(tr("Match Case"), this);
  bSelection = new QPushButton(tr("In Selection"), this);
  bClose = new QPushButton(tr("Close"), this);
  connect(bClose, SIGNAL(clicked()), SIGNAL(closeDialog()));

  bWholeWord->setToggleButton(true);
  bMatcgCase->setToggleButton(true);
  bSelection->setToggleButton(true);
}

void FindReplaceDialog::enableInSelection(bool f)
{
  bSelection->setEnabled(f);
  bSelection->setOn(f);
}

void FindReplaceDialog::exec()
{
  findBox->setFocus();
  findBox->lineEdit()->selectAll();
}

void FindReplaceDialog::prepareForFind()
{
  replaceBox->hide();
  bReplace->hide();
  bReplaceAll->hide();

  delete layout;
  layout = new QGridLayout(this, 0, 0, 0, 0);
  layout->setColStretch(0, 1);

  QHBoxLayout *options = new QHBoxLayout();
  options->addWidget(bWholeWord);
  options->addWidget(bMatcgCase);
  options->addWidget(bSelection);
  options->addWidget(bClose);

  layout->addWidget(findBox, 0, 0);
  layout->addWidget(bFind, 0, 1);
  layout->addWidget(bNext, 0, 2);
  layout->addMultiCellLayout(options, 1, 1, 0, 2);

  layout->activate();
}

void FindReplaceDialog::prepareForReplace()
{
  replaceBox->show();
  bReplace->show();
  bReplaceAll->show();

  delete layout;
  layout = new QGridLayout(this, 0, 0, 0, 0);
  layout->setColStretch(0, 1);

  QHBoxLayout *options = new QHBoxLayout();
  options->addWidget(bWholeWord);
  options->addWidget(bMatcgCase);
  options->addWidget(bSelection);
  options->addWidget(bClose);

  layout->addWidget(findBox, 0, 0);
  layout->addWidget(bFind, 0, 1);
  layout->addWidget(bReplace, 0, 2);

  layout->addWidget(replaceBox, 1, 0);
  layout->addWidget(bNext, 1, 1);
  layout->addWidget(bReplaceAll, 1, 2);

  layout->addMultiCellLayout(options, 2, 2, 0, 2);

  layout->activate();
}

QString FindReplaceDialog::findText() const
{
  return findBox->currentText();
}

QString FindReplaceDialog::replaceText() const
{
  return replaceBox->currentText();
}

bool FindReplaceDialog::wholeWord() const
{
  return bWholeWord->isOn();
}

bool FindReplaceDialog::matchCase() const
{
  return bMatcgCase->isOn();
}

bool FindReplaceDialog::inSelections() const
{
  return bSelection->isOn();
}

void FindReplaceDialog::saveText()
{
  findBox->insertItem(findBox->currentText()) ;
  replaceBox->insertItem(replaceBox->currentText()) ;
}
