#!/usr/bin/perl

my	@editor1_cpp=(qw{
	tktextaction.cpp 
	tkhighlight.cpp 
	tktextmanager.cpp
	tktexteditor.cpp
	tktextview.cpp
})	;

my	@editor2_cpp=(qw{
	tktextline.cpp
	tktextdoc.cpp
})	;

my	@editor_h=(qw{
	tkhighlight.h
})	;

my	@header_h=(qw{
	tkdockwidget.h 
	tktextdoc.h
	tktextview.h
	tkcoloractions.h
	tktabbar.h
	tktexteditor.h
	tkcustomwindow.h
	tktabwidget.h
	tktextline.h
	tkdockmanager.h
	tktextaction.h
	tktextmanager.h
})	;

my	$editor_dir = '/home/mike/Kompany/tkwidgets/src/tkqteditor' ;
my	$header_dir = '/home/mike/Kompany/tkwidgets/include' ;


sub	FixSource ($$$)
{
	my	$d	= shift	;
	my	$c	= shift	;
	my	$qr	= shift	;

	if (!open S, "$d/$c")
	{
		die "Cannot open $d/$c\n" ;
	}
	if (!open D, ">$c")
	{
		die "Cannot open $c\n" ;
	}

	LOOP : while (<S>)
	{
		if ($qr && ($_ =~ /qregexp.h/))
		{
			print	D "#ifdef\t\t_WIN32\n" 			;
			print	D "#include\t<qregexp.h>\n"		;
			print	D "#else\t\t// _WIN32\n"		;
			print	D "#include\t\"tkregexp.h\"\n"		;
			print	D "#define\t\tQRegExp\tTKRegExp\n"	;
			print	D "#endif\t\t//_WIN32\n"		;

			next	LOOP ;
		}

		if ($_ =~ /include\s*"images/)
		{
			next	LOOP ;
		}

		print	D $_ ;
	}

	close	S ;
	close	D ;
}

sub	FixHeader ($$)
{
	my	$d	= shift	;
	my	$h	= shift	;
	my	$a	= 0	;

	if (!open S, "$d/$h")
	{
		die "Cannot open $d/$h\n" ;
	}
	if (!open D, ">$h")
	{
		die "Cannot open $h\n" ;
	}

	LOOP : while (<S>)
	{
		if ($_ =~ /^class(.*)/)
		{
			if (!$a)
			{
				print	D "#include\t\"libtkwidgets_exports.h\"\n" ;
				print	D "\n" ;
				$a	= 1  ;
			}
			print	D "class LIBTKWIDGETS_API $1\n" ;
			next	LOOP ;
		}


		if ($_ =~ /qdom.h/)
		{
			print	D "#if\t\t__KB_EMBEDDED\n" 	;
			print	D "#include\t<qt.h>\n"		;
			print	D "#undef\t\tQT_NO_DOM\n"	;
			print	D "#undef\t\tQDOM_H\n"		;
			print	D "#endif\t\t//__KB_EMBEDDED\n"	;
			print	D "#include\t\"qdom.h\"\n"	;
			print	D "\n"				;

			next	LOOP ;
		}
		print	D $_ ;
	}

	close	S ;
	close	D ;
}

foreach my $cpp (@editor1_cpp)
{
	print	"Processing tkqteditor/$cpp ....\n" ;
	&FixSource ($editor_dir, $cpp, 1) ;
}

foreach my $cpp (@editor2_cpp)
{
	print	"Processing tkqteditor/$cpp ....\n" ;
	&FixSource ($editor_dir, $cpp, 0) ;
}

foreach my $h (@editor_h)
{
	print	"Processing tkqteditor/$h ....\n" ;
	&FixHeader ($editor_dir, $h) ;
}

foreach my $h (@header_h)
{
	print	"Processing include/$h ....\n" ;
	&FixHeader ($header_dir, $h) ;
}

