/*
    Copyright (C) 2001-2002 by theKompany.com <www.thekompany.com>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    See COPYING.GPL file.

    In addition, as a special exception, theKompany.com gives permission
    to link the code of this program with the tkwidgets library (or with
    modified versions of tkwidgets that use the same license as tkwidgets),
    and distribute linked combinations including the two.  You must obey
    the GNU General Public License in all respects for all of the code used
    other than tkwidgets.  If you modify this file, you may extend this
    exception to your version of the file, but you are not obligated to do so.
    If you do not wish to do so, delete this exception statement from your
    version.

    This license grants you the ability to use tkwidgets with Rekall only
    and may not be used outside of Rekall.
    See also http://www.rekall.a-i-s.co.uk/products/license.txt for details.
*/


#include	<qregexp.h>

#include "tkhighlight.h"
#include "tktextline.h"
#include "tktextmanager.h"

#include <stdlib.h>

#include <qapplication.h>
#include <qasciidict.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qmessagebox.h>
#include <qtextstream.h>

#if	0
#ifndef Q_WS_QWS
  #include <qsettings.h>
#endif
#endif

QString HighlightDebug;

static const QString sql_highlight_xml = 
"<!DOCTYPE Highlight>\n"
"<Highlight wildcards=\"*.sql\" name=\"NoHighlight\">\n"
"\n"
" <Items>\n"
"  <Text                style=\"\"  color=\"#000000\" />\n"
"  <Keyword             style=\"b\" color=\"#0000ff\" />\n"
"  <String              style=\"\"  color=\"#ff0000\" />\n"
"  <Memo                style=\"\"  color=\"#008000\" />\n"
" </Items>\n"
"\n"
" <Break>\n"
"  <normal>\n"
"   <citem item=\"\" regexp=\"--.*\"        mode=\"until, include\" lineEndContent=\"normal\" />\n"
"   <citem item=\"\" regexp=\"/\\*\"         mode=\"until, include\" lineEndContent=\"multiLineComment\" />\n"
"   <citem item=\"\" regexp=\"$\"           mode=\"until\" />\n"
"  </normal>\n"
"  <string1>\n"
"  </string1>\n"
"  <string2>\n"
"  </string2>\n"
"  <multiLineComment>\n"
"   <citem item=\"\" regexp=\"\\*/\" mode=\"until, exclude, allowfull\"/>\n"
"   <citem item=\"\" regexp=\"\\*/\" lineEndContent=\"normal\" />\n"
"  </multiLineComment>\n"
" </Break>\n"
"\n"
" <Contents>\n"
"  <normal>\n"
"   <citem item=\"Text\" regexp=\"\\s+\" />\n"
"\n"
"   <citem item=\"Keyword\" regexp=\"\\w+\" keyword=\"match view add constraint references sequence primary key foreign alter column database if exists on auto_increment unique as comment index delete from insert into select set update values where current of and create table order by drop asc desc varchar char long numeric decimal smallint integer real float double precision bit tinyint bigint binary varbinary date time timestamp not null is or like use\" caseSensitive=\"false\"/>\n"
"\n"
"   <citem item=\"Memo\" regexp=\"--.*\" />\n"
"   <citem item=\"Memo\" regexp=\"/\\*\" lineEndContent=\"multiLineComment\" />\n"
"\n"
"   <citem item=\"String\" regexp=\"&quot;\" lineEndContent=\"string1\" />\n"
"   <citem item=\"String\" regexp=\"'\" lineEndContent=\"string2\" />\n"
"\n"
"   <citem item=\"Text\" regexp=\"[\\w_]+\" lineEndContent=\"normal\" />\n"
"   <citem item=\"Text\" regexp=\"\\s+\"    lineEndContent=\"normal\" />\n"
"   <citem item=\"Text\" regexp=\"\\W\"     lineEndContent=\"normal\" />\n"
"  </normal>\n"
"\n"
"  <string1>\n"
"   <citem item=\"String\" regexp=\"&quot;\" mode=\"until, exclude, allowfull\"/>\n"
"   <citem item=\"String\" regexp=\"&quot;\" lineEndContent=\"normal\" />\n"
"  </string1>\n"
"\n"
"  <string2>\n"
"   <citem item=\"String\" regexp=\"'\" mode=\"until, exclude, allowfull\"/>\n"
"   <citem item=\"String\" regexp=\"'\" lineEndContent=\"normal\" />\n"
"  </string2>\n"
"\n"
"  <multiLineComment>\n"
"   <citem item=\"Memo\" regexp=\"\\*/\" mode=\"until, exclude, allowfull\"/>\n"
"   <citem item=\"Memo\" regexp=\"\\*/\" lineEndContent=\"normal\" />\n"
"  </multiLineComment>\n"
"\n"
" </Contents>\n"
"\n"
"</Highlight>";

QString findHighlightPath(const QString &name, const QString &res)
{
  QString globalPath = res + "/global";
  QString localPath  = res + "/local";

  QFileInfo global(globalPath, name);
  QFileInfo local(localPath, name);

  if (!local.exists())
    return global.filePath();
  else
    if (!global.exists())
      return local.filePath();

  return local.lastModified() > global.lastModified() ? local.filePath() : global.filePath();
}

#ifdef KOBOL
	// yshurik: hack for kobol austerik
	int tkhighlight_cpp_pos;
#endif
	
class TKHighlightItem
{
public:
  TKHighlightItem(int attribute, int context, int empty)
  : attr(attribute), ctx(context), empty(empty) {}

  virtual ~TKHighlightItem() {}

  virtual int find(const QChar *s, int len)
  {
#if QT_VERSION >= 300
	#ifdef KOBOL // hack for kobol austeric
		if (tkhighlight_cpp_pos!=0 && regexp.pattern()=="^\\*.*")
			return -1;
	#endif	
    regexp.search(QConstString(s, len).string());
#else
    regexp.search(QConstString((QChar *)s, len).string());
#endif
    return regexp.matchedLength();
  }

  int attr;
  int ctx;
  int empty;
  QRegExp regexp;
};

class TKHighlightUntilItem : public TKHighlightItem
{
public:
  TKHighlightUntilItem(int attribute, int context, int empty, bool inc, bool full)
  : TKHighlightItem(attribute, context, empty), inc(inc), full(full) {}

  virtual ~TKHighlightUntilItem() {};

  virtual int find(const QChar *s, int len)
  {
#if QT_VERSION >= 300
    int pos = regexp.search(QConstString(s, len).string());
#else
    int pos = regexp.search(QConstString((QChar *)s, len).string());
#endif
    if (pos != -1)
      return inc ? pos + regexp.matchedLength(): pos;

    return full ? len : -1;
  }

protected:
  bool inc;
  bool full;
};

class TKHighlightKeyword : public TKHighlightItem
{
public:
  TKHighlightKeyword(int attribute, int context, int empty, const QStringList &list, bool caseSensitive)
  : TKHighlightItem(attribute, context, empty), val(0), caseSensitive(caseSensitive)
  {
    for (QStringList::ConstIterator it = list.begin(); it != list.end(); ++it)
      dict.insert((*it).latin1(), &val);
  }

  virtual ~TKHighlightKeyword() {}

  virtual int find(const QChar *s, int len)
  {
    int l = TKHighlightItem::find(s, len);
    if (caseSensitive) {
#if QT_VERSION >= 300
      if (l > 0 && dict.find(QConstString(s, l).string().latin1()))
#else
      if (l > 0 && dict.find(QConstString((QChar *)s, l).string().latin1()))
#endif
          return l;
    } else {
#if QT_VERSION >= 300
#ifdef KOBOL
      if (l > 0 && dict.find(QConstString(s, l).string().upper().latin1()))
#else
      if (l > 0 && dict.find(QConstString(s, l).string().lower().latin1()))
#endif
#else
      if (l > 0 && dict.find(QConstString((QChar *)s, l).string().lower().latin1()))
#endif
          return l;
    }
    return -1;
  }

protected:
  int val;
  bool caseSensitive;
  QAsciiDict<int> dict;
};

TKTextHighlight::TKTextHighlight(const QString &name, TKTextEditorManager *manager)
{
  for (int z = 0; z < CTSIZE; z++) {
    contextList[z] = 0L;
    ctnList[z] = 0L;
    attributeList[z] = 0L;
  }

  /*
  QDomDocument *document = new QDomDocument();

  QFile f(findHighlightPath(name, manager->resourcesDir()));
  if (f.open(IO_ReadOnly)) {
    document->setContent(&f);
    f.close();
  } else {
    document->setContent(sql_highlight_xml);
  } */

  static QDict<QDomDocument> highlightDict;
  QDomDocument *document = highlightDict.find(name);

  if (document == 0)
  {
     QString path = findHighlightPath(name, manager->resourcesDir());
     document = new QDomDocument();                                  

     QFile f(path);
     if (f.open(IO_ReadOnly)) {
       document->setContent(&f);
       f.close();
     } else {
       document->setContent(sql_highlight_xml);
     }

     highlightDict.insert(name, document);
  }

  hname = document->documentElement().attribute("name");

  QDomElement ei = document->documentElement().namedItem("Items").firstChild().toElement();
  int id;
  for(id = 0; !ei.isNull(); ei = ei.nextSibling().toElement())
    ei.setAttribute("id", id++);

  QDomElement ec = document->documentElement().namedItem("Contents").firstChild().toElement();
  for(id = 0; !ec.isNull(); ec = ec.nextSibling().toElement())
    ec.setAttribute("id", id++);

  QDomElement en = document->documentElement().namedItem("Break").firstChild().toElement();
  for(id = 0; !en.isNull(); en = en.nextSibling().toElement())
    en.setAttribute("id", id++);

  createItemData( document, manager );
  makeCtnList(document);
  makeContextList(document);

}

TKTextHighlight::~TKTextHighlight()
{
  for (int z = 0; z < CTSIZE; z++) {
    delete contextList[z];
    delete ctnList[z];
    delete attributeList[z];
  }
}

void TKTextHighlight::createItemData( QDomDocument *document, TKTextEditorManager *manager )
{
#if	0
#ifndef Q_WS_QWS
  QSettings settings;
#endif
#endif
  QString settingsKey = manager->hlSettingsKey();
  QString hlName = document->documentElement().attribute("name");

  QDomElement e = document->documentElement().namedItem("Items").firstChild().toElement();
  for( ; !e.isNull(); e = e.nextSibling().toElement() ) {
    TKTextAttribute *a = new TKTextAttribute;
    QString color = e.attribute("color");
    QString bgcolor = e.attribute("bgcolor");
    QString style = e.attribute("style");

#if	0
#ifndef Q_WS_QWS
    if (!settingsKey.isEmpty()) {
      QString key = settingsKey + "/" + hlName + "/" + e.nodeName();
      style = settings.readEntry(key + "/style", style);
      color = settings.readEntry(key + "/color", color);
      bgcolor = settings.readEntry(key + "/bgcolor", bgcolor);
    }
#endif
#endif
    int bold = style.find("b") != -1 ? 1:-0;
    int italic = style.find("i") != -1 ? 1:0;
    a->color = QColor(color);
    a->usebg = false;
    if (!bgcolor.isEmpty()) {
      a->usebg = true;
      a->bgcolor = QColor(bgcolor);
    }
    a->fontType = 2 * bold + italic;
    a->itemName = e.nodeName();

    attributeList[e.attribute("id").toInt()] = a;
  }
}

void TKTextHighlight::makeCtnList(QDomDocument *document)
{
  QDomElement contents = document->documentElement().namedItem("Break").toElement();

  QDomElement e = contents.firstChild().toElement();
  for(; !e.isNull(); e = e.nextSibling().toElement()) {
    HighlightContext *c = new HighlightContext();
    c->setAutoDelete(true);

    QDomElement s = e.firstChild().toElement();
    for(; !s.isNull(); s = s.nextSibling().toElement()) {
      TKHighlightItem *i = 0;
      int lineEndContext = s.hasAttribute("lineEndContent") ? contents.namedItem(s.attribute("lineEndContent")).toElement().attribute("id").toInt() : -1;
      int emptyContext = s.hasAttribute("emptyContent") ? contents.namedItem(s.attribute("emptyContent")).toElement().attribute("id").toInt() : -1;
      QString type = s.attribute("type");
      QString regexp = s.attribute("regexp");

      bool mUntil = false;
      bool mInclude = false;
      bool mFull = false;
      bool mMinimum = false;
      bool mNoCaseSensitive = false;
      if (s.hasAttribute("mode")) {
        QString mode = s.attribute("mode");
        mUntil = mode.find("until", false) != -1;
        mInclude = mode.find("include", false) != -1;
        mInclude = mode.find("exclude", false) == -1;
        mFull = mode.find("allowfull", false) != -1;
        mMinimum = mode.find("minimal", false) != -1;
        mNoCaseSensitive = mode.find("noCaseSensitive", false) != -1;
      }

      if (!mUntil)
        regexp.prepend("^");

      if (s.hasAttribute("keyword")) {
        QStringList list = QStringList::split(' ', s.attribute("keyword"));
        i = new TKHighlightKeyword(0, lineEndContext, emptyContext, list, s.attribute("caseSensitive") != "false");
      } else
        if (mUntil)
          i = new TKHighlightUntilItem(0, lineEndContext, emptyContext, mInclude, mFull);
        else
          i = new TKHighlightItem(0, lineEndContext, emptyContext);

      if (mNoCaseSensitive)
        i->regexp.setCaseSensitive(false);

      i->regexp.setPattern(regexp);
      i->regexp.setMinimal(mMinimum);

      c->append(i);
    }
    ctnList[e.attribute("id").toInt()] = c;
  }
}

void TKTextHighlight::makeContextList(QDomDocument *document)
{
  QDomElement items = document->documentElement().namedItem("Items").toElement();
  QDomElement contents = document->documentElement().namedItem("Contents").toElement();

  QDomElement e = contents.firstChild().toElement();
  for( ; !e.isNull(); e = e.nextSibling().toElement() ) {
    HighlightContext *c = new HighlightContext();
    c->setAutoDelete(true);

    QDomElement s = e.firstChild().toElement();
    for( ; !s.isNull(); s = s.nextSibling().toElement() ) {
      TKHighlightItem *i = 0;
      int attribute = items.namedItem(s.attribute("item")).toElement().attribute("id").toInt();
      int lineEndContext = s.hasAttribute("lineEndContent") ? contents.namedItem(s.attribute("lineEndContent")).toElement().attribute("id").toInt() : -1;
      int emptyContext = s.hasAttribute("emptyContent") ? contents.namedItem(s.attribute("emptyContent")).toElement().attribute("id").toInt() : -1;
      QString type = s.attribute("type");
      QString regexp = s.attribute("regexp");

      bool mUntil = false;
      bool mInclude = false;
      bool mFull = false;
      bool mMinimum = false;
      bool mNoCaseSensitive = false;
      if (s.hasAttribute("mode")) {
        QString mode = s.attribute("mode");
        mUntil = mode.find("until", false) != -1;
        mInclude = mode.find("include", false) != -1;
        mInclude = mode.find("exclude", false) == -1;
        mFull = mode.find("allowfull", false) != -1;
        mMinimum = mode.find("minimal", false) != -1;
        mNoCaseSensitive = mode.find("noCaseSensitive", false) != -1;
      }

      if (!mUntil)
        regexp.prepend("^");

      if (s.hasAttribute("keyword")) {
        QStringList list = QStringList::split(' ', s.attribute("keyword"));
        i = new TKHighlightKeyword(attribute, lineEndContext, emptyContext, list, s.attribute("caseSensitive") != "false");
      } else
        if (mUntil)
          i = new TKHighlightUntilItem(attribute, lineEndContext, emptyContext, mInclude, mFull);
        else
          i = new TKHighlightItem(attribute, lineEndContext, emptyContext);

      if (mNoCaseSensitive)
        i->regexp.setCaseSensitive(false);

      i->regexp.setPattern(regexp);
      i->regexp.setMinimal(mMinimum);
      c->append(i);
    }
    contextList[e.attribute("id").toInt()] = c;
  }
}

#ifdef KOBOL
	// yshurik: hack for kobol austerik
	#define pos tkhighlight_cpp_pos
#endif

//#define HLDEBUG
void TKTextHighlight::highlight(TKTextLine *textLine)
{
#ifdef HLDEBUG
//  #define debug HighlightDebug += '\n';HighlightDebug += QString().sprintf
  static bool error = false;
  if (error) {
    textLine->setAttributes(0, 0, textLine->length());
    return;
  }
#endif

  if(textLine->status() & TKTextLine::Wrapped)
      return;
  HighlightContext *context = contextList[textLine->highlightContext()];

  const QChar *s = textLine->unicode();
#ifdef KOBOL
	pos = 0; // get it from global
#else
  int pos = 0;
#endif
  int len = textLine->length();

#ifdef HLDEBUG
  debug("--------------------------------------------------------------");
  debug("start context=%d\n%s|", textLine->context(), QConstString(textLine->unicode(), textLine->length()).string().latin1());
#endif
  while (len > 0) {
    bool found = false;
#ifdef HLDEBUG
    debug("restart... "+(*textLine));
#endif
    for (TKHighlightItem *item = context->first(); item; item = context->next()) {
      int l = item->find(s, len);
      if (l > 0) {
        found = true;
#ifdef HLDEBUG
        QString dbg = QConstString(s, l).string();
//        int idd = context->items.at();
//        if (!dbg.isEmpty())
//          debug("%d\tlen=%d\tpos=%d\tlength=%d\t:%s", idd, l, pos, textLine->length(), (const char *)dbg);
#endif
        textLine->setAttributes(item->attr, pos, pos + l);
        pos += l;
        s += l;
        len -= l;
        if (item->ctx != -1) {
#ifdef HLDEBUG
          debug("CONTEXT1=%d", item->ctx);
#endif
          context = contextList[item->ctx];
          break;
        }
      } else {
        if (item->empty != -1) {
	  found = true;
#ifdef HLDEBUG
          debug("CONTEXT2=%d", item->empty);
#endif
          context = contextList[item->empty];
          break;
        }
      }
    }

    if (!found) {
	textLine->setAttributes(0, pos, pos+1);
	pos++;
	len--;
    }

#ifdef HLDEBUG
    if (!found) {
      debug("BUG!!!");
      error = true;
      textLine->setAttributes(0, 0, textLine->length());
      return;
    }
#endif

  }

  textLine->doneHighlight();
  return;
}

#ifdef KOBOL
	// yshurik: hack for kobol austerik
	#undef pos
#endif

int TKTextHighlight::doHighlight(int ctx, TKTextLine *textLine)
{
  HighlightContext *context = ctnList[ctx];
  if(!(textLine->status() & TKTextLine::Wrapped))
    textLine->resetHighlight(ctx);
  const QChar *s = textLine->unicode();
  int pos = 0;
  int len = textLine->length();
  while (len > 0) {
    for (TKHighlightItem *item = context->first(); item; item = context->next()) {
      int l = item->find(s, len);
      if (l > 0) {
        pos += l;
        s += l;
        len -= l;
        if (item->ctx != -1) {
          ctx = item->ctx;
          context = ctnList[ctx];
          break;
        }
      } else
        if (item->empty != -1) {
          ctx = item->empty;
          context = ctnList[ctx];
          break;
        }
    }
  }
  return ctx;
}
//----------------------------------------------------------------------------------------------------------------

HighlightDataDict *TKTextHighlightManager::highlights(TKTextEditorManager *manager)
{
  HighlightDataDict *dict = new HighlightDataDict;
	dict->setAutoDelete(true);

  QString globalPath = manager->resourcesDir() + "/global";
  QString localPath  = manager->resourcesDir() + "/local";

  QStringList list;
  if (QFileInfo(globalPath).exists())
    list += QDir(globalPath).entryList(QDir::Files);
  if (QFileInfo(localPath).exists())
    list += QDir(localPath).entryList(QDir::Files);

  while (!list.isEmpty()) {
    QString name = list.first();
    list.remove(name);
    QFile f(findHighlightPath(name, manager->resourcesDir()));
    if (!f.open(IO_ReadOnly))
      continue;

    QDomDocument *document = new QDomDocument();
    document->setContent(&f);
    f.close();

    TKHighlightData *hd = new TKHighlightData;
    hd->name = document->documentElement().attribute("name");
    hd->mask = document->documentElement().attribute("wildcards");

#if	0
#ifndef Q_WS_QWS
    if (!manager->hlSettingsKey().isEmpty()) {
      QSettings settings;
      hd->mask = settings.readEntry(manager->hlSettingsKey() + "/" + hd->name + " wildcards", hd->mask);
    }
#endif
#endif
    hd->path = name;

    if (!hd->name.isEmpty())
      dict->insert(hd->name, hd);
		delete document;
  }

  if (!dict->find("NoHighlight")) {
    const char *def =
    "<!DOCTYPE Highlight ><Highlight wildcards=\"\" name=\"NoHighlight\" > \n"
    " <Items>                                                                                       \n"
    "  <Text color=\"#000000\" />                                                                   \n"
    " </Items>                                                                                      \n"
    " <Break>                                                                                       \n"
    "  <normal>                                                                                     \n"
    "   <citem item=\"\" regexp=\"$\" mode=\"until\" />                                             \n"
    "  </normal>                                                                                    \n"
    " </Break>                                                                                      \n"
    " <Contents>                                                                                    \n"
    "  <normal>                                                                                     \n"
    "   <citem item=\"Text\" regexp=\"$\" mode=\"until\" />                                         \n"
    "  </normal>                                                                                    \n"
    " </Contents>                                                                                   \n"
    "</Highlight>";

    QFile f(globalPath + "/nohighlight");
    QTextStream ts(&f);
    if (f.open(IO_WriteOnly)) {
      ts << def;
      f.close();
      f.open(IO_ReadOnly);
      QDomDocument* document = new QDomDocument();
      document->setContent(&f);
      f.close();

      TKHighlightData *hd = new TKHighlightData;
      hd->name = document->documentElement().attribute("name");
      hd->mask = document->documentElement().attribute("wildcards");
      hd->path = "nohighlight";
      dict->insert(hd->name, hd);
      delete document;
    } else {
      QDomDocument* document = new QDomDocument();
      document->setContent(QString(def));

      TKHighlightData *hd = new TKHighlightData;
      hd->name = document->documentElement().attribute("name");
      hd->mask = document->documentElement().attribute("wildcards");
      hd->path = "nohighlight";
      dict->insert(hd->name, hd);
      delete document;
    }
  }

  if (!dict->find("NoHighlight")) {
    QMessageBox::critical(0, "Editor", "Cannot find default highlight file");
    QApplication::exit(0);
  }

  return dict;
}

TKTextHighlight* TKTextHighlightManager::findHighlight(TKTextEditorManager *manager, const QString &fileName)
{
  HighlightDataDict *dict = TKTextHighlightManager::highlights(manager);
  QString defPath = dict->find("NoHighlight")->path;

  QDictIterator<TKHighlightData> it(*dict);
  while (it.current()) {
    if (QDir::match(it.current()->mask, fileName)) {
      QString path = it.current()->path;
      delete dict;
      return new TKTextHighlight(path, manager);
    }
    ++it;
  }
  return new TKTextHighlight(defPath, manager);
}

TKTextHighlight *TKTextHighlightManager::highlight(TKTextEditorManager *manager, const QString &highlightName)
{
  if (highlightName.at(0) == '/')
    return new TKTextHighlight(highlightName, manager);

  HighlightDataDict *dict = TKTextHighlightManager::highlights(manager);
  QString path = dict->find("NoHighlight")->path;

  if (!highlightName.isEmpty() && dict->find(highlightName))
    path = dict->find(highlightName)->path;

  delete dict;
  return new TKTextHighlight(path, manager);
}
