/***************************************************************************
    file	         : kb_componentbase.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qwidget.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_attrdict.h"
#include	"kb_database.h"
#include	"kb_gui.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_display.h"
#include	"kb_component.h"
#include	"kb_options.h"
#include	"kb_string.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_docroot.h"
#include	"kb_viewer.h"
#include	"kb_build.h"

#include	"kb_classes.h"


#include	"kb_objbase.h"

#ifndef 	_WIN32
#include	"kb_componentbase.moc"
#else
#include 	"kb_componentbase.h"
#endif

#include	"kb_componentlist.h"


/*  KBComponentBase							*/
/*  KBComponentBase							*/
/*		: Constructor for base object for components		*/
/*  parent	: QObject *	: Parent object				*/
/*  name	: cchar *	: Object name				*/
/*  (returns)	: KBForm	:					*/

KBComponentBase::KBComponentBase
	(	QObject		*parent,
		cchar		*name
	)
	:
	KBObjBase (parent, name)
{
	m_docRoot = 0 ;
	m_viewer  = 0 ;
}

/*  KBComponentBase							*/
/*  ~KBComponentBase							*/
/*		: Destructor for base object for components		*/
/*  (returns)	:		:					*/

KBComponentBase::~KBComponentBase ()
{
	DELOBJ (m_docRoot) ;
}

/*  KBComponentBase	:						*/
/*  build	: Build an instance of an object			*/
/*  location	: KBLocation &	  : Object location			*/
/*  create	: bool		  : Creating a new object		*/
/*  pDict	: QDict<QString>& : Parameter dictionary		*/
/*  pError	: KBError &	  : Error return			*/
/*  (returns)	: bool		  :					*/

bool	KBComponentBase::build
	(	KBLocation	&location,
		bool		create,
		KBError		&pError
	)
{
	setLocation (location) ;

	if (create)
	{
		KBAttrDict	aList	;

		aList.addValue ("name",	    "UnnamedComponent") ;
		aList.addValue ("language", "py") ;
		aList.addValue ("w",	    KBOptions::getFormWidth ()) ;
		aList.addValue ("h",	    KBOptions::getFormHeight()) ;

		bool	ok ;
		m_docRoot = new KBComponent (getLocation(), aList, ok) ;
		if (!ok)
		{	pError	= KBError
				  (	KBError::Warning,
					TR("User cancel"),
					QString::null,
					__ERRLOCN
				  )	;
			return	false	;
		}
	}
	else
	{
		QByteArray doc ;

		if (!getLocation().contents (doc, pError))
			return	false	;

		if ((m_docRoot = KBOpenComponentText (getLocation(), doc, pError)) == 0)
			return	false	;
	}

	return	true	;
}

/*  KBComponentBase	:							*/
/*  show	: Show form						*/
/*  showAs	: KB::ShowAs	  : Display mode, always design		*/
/*  pDict	: QDict<QString> &: Parameter dictionary		*/
/*  embed	: QWidget *	  : Widget into which to embed display	*/
/*  pError	: KBError &	  : Error return			*/
/*  key		: const KBValue & : Parent key				*/
/*  rDict	: QDict<QString>* : Results dictionary			*/
/*  (returns)	: KB::ShowRC	  : Startup result			*/

KB::ShowRC
	KBComponentBase::show
	(	KB::ShowAs		,
		const QDict<QString>	&pDict,
		QWidget			*embed,
		KBError			&pError,
		const KBValue		&,
		QDict<QString>		*
	)
{
	if (m_viewer == 0)
	{
		m_viewer = new KBComponentViewer
			   (		this,
					embed,
					pDict
			   )	;

		setPart	(m_viewer, false) ;
		KB::ShowRC rc = m_viewer->startup (m_docRoot, pError) ;

		if (rc != KB::ShowRCOK)
		{
			delete	m_viewer;
			return	rc	;
		}

		return	KB::ShowRCOK	;
	}

	KBPartWidget *pw = m_viewer->getPartWidget() ;
	pw->show		() ;
	pw->raise		() ;
	pw->setActiveWindow	() ;

	m_viewer->showAs(KB::ShowAsDesign) ;
	return	KB::ShowRCOK	;
}

QString	KBComponentBase::def ()
{
	QString	text	;
	m_docRoot->printNode (text, 0) ;
	return	text	;
}

void	KBComponentBase::widgetClosing ()
{
	DELOBJ (m_docRoot) ;
}


/*  -----------------------------------------------------------------  */

KBFACTORYIMPL
(	KBComponentFactory,
	componentview,
	"Rekall component viewer",
	"Plugin",
	"0",
	"7",
	"0"
)


QObject	*KBComponentFactory::create
	(	QObject		  *parent,
		cchar		  *name,
		cchar		  *className,
		const QStringList &
	)
{
	if ((className != 0) && (strcmp (className, "browser") == 0))
		return	new KBComponentList ((QWidget *)parent, (KBDBInfo *)name) ;

	return	new KBComponentBase (parent) ;
}

cchar	*KBComponentFactory::ident ()
{
	return	__KB_BUILD_IDENT	;
}
